/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.httpserver;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.concurrent.Future;
import javax.servlet.DispatcherType;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.etc.util.EtcEnumStrUtil;
import jp.co.extreme.httpserver.HtsvContainer;
import jp.co.extreme.httpserver.HtsvResourceHolder;
import jp.co.extreme.httpserver.HtsvSiteContext;
import jp.co.extreme.module.wbfw.servlet.WbfwFrontServlet;
import jp.co.extreme.module.wbfw.servlet.WbfwServletContextListener;
import jp.co.extreme.module.wbfw.servlet.WbxFilter;
import jp.co.extreme.module.xdts.wcb.XdtsDataViewMenuWCB;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.web.XwebMainServlet;
import jp.co.extreme.task.TskAbstractCallable2;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.LifeCycle;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

class XdtsHttpServerTask
extends TskAbstractCallable2
implements LifeCycle.Listener {
    public Future future;
    public HtsvSiteContext siteContext;
    public String hostName;
    public int port;
    public int sessionTimeout;
    public Server server;

    public XdtsHttpServerTask() {
        this.setName("HTTP Server");
    }

    public Object taskProcess() throws Exception {
        this.taskProcess_L2();
        return null;
    }

    protected void taskProcess_L2() throws Exception {
        HtsvContainer webContainer;
        this.siteContext.sessionValidationInterval = 60;
        this.siteContext.sessionTimeout = this.sessionTimeout;
        String resourceDirPath = "${APP}http_server/resource";
        File resourceDir = new File(AfbApplication.getInstance().toReal(resourceDirPath));
        this.getLogger().info("start:resourceDir=" + resourceDir.getPath());
        this.siteContext.resourceDirList.clear();
        this.siteContext.resourceDirList.add(new File(resourceDir, "option"));
        this.siteContext.resourceDirList.add(new File(resourceDir, "default"));
        this.siteContext.resourceDirList.add(resourceDir);
        String function = EtcEnumStrUtil.toElement(WbxConstants.SiteFunction.dbTool.name());
        this.getLogger().debug("function=" + function);
        this.siteContext.propertyMap.put(WbxConstants.SitePropertyKey.function.name(), function);
        this.siteContext.theme = "dark_gray_blue";
        this.siteContext.homePath = XdtsDataViewMenuWCB.Method.dataViewMenu.getPath();
        HtsvResourceHolder.getInstance().webContainer = webContainer = new HtsvContainer();
        webContainer.siteContextDefault = this.siteContext;
        String serverName = String.valueOf(this.hostName) + ":" + this.port;
        webContainer.serverNameMap.put(serverName, this.siteContext);
        webContainer.mainServlet = new XwebMainServlet();
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        ServletHolder servletHolder = new ServletHolder(WbfwFrontServlet.class);
        servletContextHandler.addServlet(servletHolder, "/");
        servletContextHandler.addFilter(WbxFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        WbfwServletContextListener servletContextListener = new WbfwServletContextListener();
        servletContextListener.appStart = false;
        servletContextHandler.addEventListener((EventListener)((Object)servletContextListener));
        HandlerList handlerList = new HandlerList();
        handlerList.addHandler((Handler)servletContextHandler);
        this.server = new Server();
        this.server.setHandler((Handler)handlerList);
        ArrayList<ServerConnector> serverConnectorList = new ArrayList<ServerConnector>();
        ArrayList<String> hostList = new ArrayList<String>();
        hostList.add(this.hostName);
        int i = 0;
        while (i < hostList.size()) {
            String host = (String)hostList.get(i);
            ServerConnector serverConnector = new ServerConnector(this.server);
            serverConnector.setHost(host);
            serverConnector.setPort(this.port);
            serverConnectorList.add(serverConnector);
            ++i;
        }
        ServerConnector[] serverConnectors = serverConnectorList.toArray(new ServerConnector[0]);
        this.getLogger().info("Server Connector count =" + serverConnectors.length);
        this.server.setConnectors((Connector[])serverConnectors);
        this.server.addLifeCycleListener((LifeCycle.Listener)this);
        this.server.start();
        this.server.join();
    }

    @Override
    protected void handleException(Throwable throwable) {
        this.getLogger().info("handleException;#1");
        super.handleException(throwable);
    }

    public void lifeCycleStarting(LifeCycle lifeCycle) {
        this.getLogger().info("HTTP Server is starting...");
    }

    public void lifeCycleStarted(LifeCycle lifeCycle) {
        this.getLogger().info("HTTP Server started.");
        String url = "http://" + this.hostName + ":" + this.port;
        this.getLogger().debug("Connecting to '" + url + "'...");
        try {
            Document document = Jsoup.connect((String)url).timeout(180000).get();
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
        }
    }

    public void lifeCycleStopping(LifeCycle lifeCycle) {
        this.getLogger().info("HTTP Server is stopping...");
    }

    public void lifeCycleStopped(LifeCycle lifeCycle) {
        this.getLogger().info("HTTP Server has stopped.");
    }
}

