/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.stage.Window;
import jp.co.extreme.base.util.BcInputValidator;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxPasswordField;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.XdtsProfileWizard;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.scf4.fx.XdtsWizardPane;
import jp.co.extreme.sql.SqlConstants;
import jp.co.extreme.sql.SqlWords;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.context.SqlContextFactory;

public class Z_XdtsProfileEditPane
extends XdtsWizardPane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField productNameTextField = new FxTextField();
    FxTextField profileNameTextField = new FxTextField();
    FxTextField driverTextField = new FxTextField();
    FxTextField jdbcUrlTextField = new FxTextField();
    FxTextField userTextField = new FxTextField();
    FxPasswordField passwordField = new FxPasswordField();
    FxTextField groupTextField = new FxTextField();
    FxTextField noteTextField = new FxTextField();
    XdtsProfile profile;
    XdtsProfileWizard wizard;
    SqlConstants.DatabaseProduct databaseProduct;
    SqlContext sqlContext;

    public Z_XdtsProfileEditPane(XdtsProfileWizard wizard) throws Exception {
        this.wizard = wizard;
        this.profile = wizard.profile1;
        this.initComponent();
    }

    @Override
    public void initComponent() throws Exception {
        super.initComponent();
        this.mainDecoratePane.setCenter((Node)this.centerPane);
        this.databaseProduct = SqlConstants.DatabaseProduct.getById(this.profile.productId);
        this.sqlContext = SqlContextFactory.getSqlContext(this.databaseProduct.id);
        this.setComponant_common1();
        this.setComponant_common2();
        this.setComponant_common3();
    }

    protected void setComponant_common1() throws Exception {
        this.previousButton.setVisible(true);
        this.nextButton.setText(BcWords.getInstance().completion);
        this.nextButton.setVisible(true);
        this.cancelButton.setVisible(true);
        this.productNameTextField.setPrefColumnCount(60);
        this.productNameTextField.setEditable(false);
        this.productNameTextField.setText(this.databaseProduct.productName);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().productName), new Node[]{this.productNameTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.profileNameTextField.setPrefColumnCount(40);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().dataSourceName), new Node[]{this.profileNameTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.driverTextField.setPrefColumnCount(80);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().driverClass), new Node[]{this.driverTextField});
        this.centerPane.addNodeUnit(nodeUnit);
    }

    protected void setComponant_common2() throws Exception {
        this.jdbcUrlTextField.setPrefColumnCount(80);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().jdbcUrl), new Node[]{this.jdbcUrlTextField});
        this.centerPane.addNodeUnit(nodeUnit);
    }

    protected void setComponant_common3() throws Exception {
        this.userTextField.setPrefColumnCount(20);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().user), new Node[]{this.userTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.passwordField.setPrefColumnCount(20);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().password), new Node[]{this.passwordField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.groupTextField.setPrefColumnCount(20);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().group), new Node[]{this.groupTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.noteTextField.setPrefColumnCount(80);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().note), new Node[]{this.noteTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        FxUtil.defaultInitialize((Node)this);
        this.setPrefHeight(150.0);
    }

    protected BcResult validateInputValue() throws Exception {
        BcResult result = new BcResult();
        BcInputValidator inputValidator = BcInputValidator.getInstance();
        inputValidator.notNullable(SqlWords.getInstance().dataSourceName, this.profileNameTextField.getText(), result.getErrorList());
        inputValidator.notNullable(SqlWords.getInstance().driverClass, this.driverTextField.getText(), result.getErrorList());
        inputValidator.notNullable(SqlWords.getInstance().jdbcUrl, this.jdbcUrlTextField.getText(), result.getErrorList());
        return result;
    }

    protected void dataStore_common() throws Exception {
        this.profile.name = this.profileNameTextField.getText();
        this.profile.driver = this.driverTextField.getText();
        this.profile.url = this.jdbcUrlTextField.getText();
        this.profile.user = this.userTextField.getText();
        this.profile.password = this.passwordField.getText();
        this.profile.group = this.groupTextField.getText();
        this.profile.note = this.noteTextField.getText();
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
    }

    @Override
    protected void previousButtonAction() throws Exception {
    }

    @Override
    protected void nextButtonAction() throws Exception {
        BcResult result = this.validateInputValue();
        if (result.hasError()) {
            String message = BcMessageCreator.getInstance().createMessage(result.getErrorList());
            FxOptionPane.showMessageDialog((Window)this.wizard.stage, (Object)message, BcWords.getInstance().warning, 2);
            return;
        }
        this.dataStore_common();
        this.wizard.step_finish();
    }

    @Override
    protected void cancelButtonAction() throws Exception {
        this.wizard.closeConfirm();
    }
}

