/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.dao;

import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.xdts.model.XdtsCustomSql;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class XdtsCustomSqlDAO
extends OrmAbstractDAO<XdtsCustomSql> {
    private XdtsCustomSqlDAO() {
        super(new XdtsCustomSql[0]);
        this.setTableName("xdts_custom_sql");
        this.setViewName(String.valueOf(this.tableName) + "__v1");
    }

    public static XdtsCustomSqlDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, Mode mode, String alias, long entityId, long dataSourceId, String entityName) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (entityId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id = " + entityId);
            selectQuery.addWhereElement(whereElement);
        }
        if (dataSourceId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "profile_id = " + dataSourceId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(entityName)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "name " + sqlContext.toCondition_string("=", entityName));
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(SqlUtil.createTableName(this.getViewName(), alias));
        switch (mode) {
            case id: {
                selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "id");
                break;
            }
            case dataSourceId: {
                selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "profile_id");
                selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "id");
            }
        }
        String query = sqlContext.buildSelectQuery(selectQuery);
        this.getLogger().debug("query=" + query);
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, long entityId, long dataSourceId, String entityName) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "ctsql";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, entityId, dataSourceId, entityName);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(null));
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public <T> T getById(DtsSession dtsSession, long entityId) throws Exception {
        int profileId = -1;
        String entityName = null;
        List<T> entityList = this.getList(dtsSession, Mode.id, entityId, profileId, entityName);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> T getByName(DtsSession dtsSession, long profileId, String entityName) throws Exception {
        if (BcStringUtil.isEmpty(entityName)) {
            return null;
        }
        int entityId = -1;
        List<T> entityList = this.getList(dtsSession, Mode.dataSourceId, entityId, profileId, entityName);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> List<T> getList(DtsSession dtsSession, long dataSourceId) throws Exception {
        return this.getList(dtsSession, Mode.dataSourceId, -1L, dataSourceId, null);
    }

    /* synthetic */ XdtsCustomSqlDAO(XdtsCustomSqlDAO xdtsCustomSqlDAO) {
        this();
    }

    public static enum Mode {
        id,
        dataSourceId;

    }

    private static final class SingletonHolder {
        private static final XdtsCustomSqlDAO instance = new XdtsCustomSqlDAO(null);

        private SingletonHolder() {
        }
    }
}

