/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcInteger;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.util.EtcRsmdSupplement;
import jp.co.extreme.module.xdts.common.TemSqlParser;
import jp.co.extreme.module.xdts.common.XdtsSqlConditionUtil;
import jp.co.extreme.module.xdts.common.XdtsSqlParserUtil;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.model.v001.XdtsColumn;
import jp.co.extreme.module.xdts.model.v001.XdtsControlContext;
import jp.co.extreme.module.xdts.model.v001.XdtsElemet;
import jp.co.extreme.module.xdts.model.v001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.model.v001.XdtsOrderBy;
import jp.co.extreme.module.xdts.model.v001.XdtsOrderByElement;
import jp.co.extreme.module.xdts.model.v001.XdtsSelect;
import net.sf.jsqlparser.Model;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.WithItem;

public class XdtsSqlParser
extends BcLoggableObject {
    public EtcRsmdSupplement rsmdSupplement;
    public Map<String, String> map;

    public Select extractSelect(String sql) throws Exception {
        Statement statement2;
        Statements statements = CCJSqlParserUtil.parseStatements((String)sql);
        List statementLsitList = statements.getStatements();
        this.getLogger().debug("Statement\u6570=" + statementLsitList.size());
        for (Statement statement2 : statementLsitList) {
            this.getLogger().debug("statement=" + statement2);
        }
        if (statementLsitList.size() > 1) {
            String msg = "Statement\u304c\u8907\u6570\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002Statement\u6570=" + statementLsitList.size();
            throw new Exception(msg);
        }
        statement2 = (Statement)BcCollectionUtil.getFirst(statementLsitList);
        Select select = null;
        if (statement2 instanceof Select) {
            select = (Select)statement2;
        }
        return select;
    }

    public XdtsExtractionCondition createExtractionCondition(String query) throws Exception {
        TemSqlParser temSqlParser = new TemSqlParser();
        String queryWk = temSqlParser.parse(query);
        this.map = temSqlParser.map;
        Select select = this.extractSelect(queryWk);
        if (select == null) {
            return null;
        }
        XdtsExtractionCondition extractionCondition = new XdtsExtractionCondition();
        extractionCondition.selectList = new ArrayList<XdtsSelect>();
        extractionCondition.sqlOrign = query;
        this.rsmdSupplement = new EtcRsmdSupplement();
        this.parseSelect(select, extractionCondition);
        XdtsUtil.controlFidden(extractionCondition);
        return extractionCondition;
    }

    public void parseSelect(Select select, XdtsExtractionCondition extractionCondition) throws Exception {
        SelectBody selectBody = select.getSelectBody();
        this.parseSelectBody(selectBody, extractionCondition, null, null);
        List withItemList = select.getWithItemsList();
        if (withItemList != null) {
            for (WithItem withItem : withItemList) {
            }
        }
    }

    public void parseSelectBody(SelectBody selectBody, XdtsExtractionCondition extractionCondition, XdtsSelect parentXdtsSelect, XdtsElemet parentXdtsElemet) throws Exception {
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            XdtsSelect xdtsSelect = this.createSelectContext(plainSelect, extractionCondition, parentXdtsSelect, parentXdtsElemet);
        } else if (selectBody instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)selectBody;
            List selectBodyList = setOperationList.getSelects();
            this.parse(setOperationList, extractionCondition, parentXdtsSelect, parentXdtsElemet);
        } else {
            throw new Exception("selectBody class=" + selectBody.getClass().getName());
        }
    }

    public void parse(SetOperationList setOperationList, XdtsExtractionCondition extractionCondition, XdtsSelect parentXdtsSelect, XdtsElemet parentXdtsElemet) throws Exception {
        List selectBodyList = setOperationList.getSelects();
        for (SelectBody selectBody : selectBodyList) {
            this.parseSelectBody(selectBody, extractionCondition, parentXdtsSelect, parentXdtsElemet);
        }
        List bracketList = setOperationList.getBrackets();
        List operationList = setOperationList.getOperations();
        List orderByElement = setOperationList.getOrderByElements();
    }

    public void parseFrom(FromItem fromItem, XdtsExtractionCondition extractionCondition, XdtsSelect parentXdtsSelect, XdtsElemet parentXdtsElemet, BcInteger hierarchy) throws Exception {
        if (hierarchy == null) {
            hierarchy = new BcInteger();
        }
        ++hierarchy.value;
        this.getLogger().debug(XdtsSqlParserUtil.expressionLog("fromItem-" + hierarchy, (Model)fromItem));
        if (fromItem instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)fromItem;
            this.parseSubSelect(subSelect, extractionCondition, parentXdtsSelect, parentXdtsElemet);
        } else if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            this.visitTabale(table);
        } else if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            this.parseSubJoin(subJoin, extractionCondition, parentXdtsSelect, parentXdtsElemet, hierarchy);
        } else {
            throw new Exception(fromItem.getClass().getName());
        }
    }

    public void parseSubJoin(SubJoin subJoin, XdtsExtractionCondition extractionCondition, XdtsSelect parentXdtsSelect, XdtsElemet parentXdtsElemet, BcInteger hierarchy) throws Exception {
        this.parseFrom(subJoin.getLeft(), extractionCondition, parentXdtsSelect, parentXdtsElemet, hierarchy);
        for (Join join : subJoin.getJoinList()) {
            this.parseJoin(join, extractionCondition, parentXdtsSelect, parentXdtsElemet, hierarchy);
        }
    }

    public void parseJoin(Join join, XdtsExtractionCondition extractionCondition, XdtsSelect parentXdtsSelect, XdtsElemet parentXdtsElemet, BcInteger hierarchy) throws Exception {
        this.getLogger().debug(XdtsSqlParserUtil.expressionLog("Join", join));
        this.parseFrom(join.getRightItem(), extractionCondition, parentXdtsSelect, parentXdtsElemet, hierarchy);
    }

    public void parseSubSelect(SubSelect subSelect, XdtsExtractionCondition extractionCondition, XdtsSelect parentXdtsSelect, XdtsElemet parentXdtsElemet) throws Exception {
        SelectBody selectBody = subSelect.getSelectBody();
        this.parseSelectBody(selectBody, extractionCondition, parentXdtsSelect, parentXdtsElemet);
        List withItemsList = subSelect.getWithItemsList();
    }

    public void parseWhere(Expression where, XdtsExtractionCondition extractionCondition, XdtsSelect parentXdtsSelect, XdtsElemet parentXdtsElemet) throws Exception {
        if (where == null) {
            return;
        }
        if (where instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)where;
            Expression leftExpression = binaryExpression.getLeftExpression();
            this.parseWhere(leftExpression, extractionCondition, parentXdtsSelect, parentXdtsElemet);
            Expression rightExpression = binaryExpression.getRightExpression();
            this.parseWhere(rightExpression, extractionCondition, parentXdtsSelect, parentXdtsElemet);
        } else if (where instanceof Parenthesis) {
            Parenthesis parenthesis = (Parenthesis)where;
            this.parseWhere(parenthesis.getExpression(), extractionCondition, parentXdtsSelect, parentXdtsElemet);
        } else if (where instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)where;
            this.parseSubSelect(subSelect, extractionCondition, parentXdtsSelect, parentXdtsElemet);
        }
    }

    public XdtsSelect createSelectContext(PlainSelect plainSelect, XdtsExtractionCondition extractionCondition, XdtsSelect parentXdtsSelect, XdtsElemet parentXdtsElemet) throws Exception {
        XdtsOrderBy xdtsOrderBy;
        Expression expression;
        int i;
        XdtsSelect xdtsSelect = new XdtsSelect();
        xdtsSelect.controlContextList = new ArrayList<XdtsControlContext>();
        xdtsSelect.id = extractionCondition.selectList.size();
        xdtsSelect.queryOrign = plainSelect.toString();
        extractionCondition.selectList.add(xdtsSelect);
        String placeholder = XdtsSqlParserUtil.toPlaceholderSubSelect(xdtsSelect.id);
        if (parentXdtsElemet != null) {
            String str;
            parentXdtsElemet.template = str = XdtsSqlParserUtil.replaceFirst(parentXdtsElemet.template, plainSelect.toString(), placeholder);
        }
        xdtsSelect.columnList = new ArrayList<XdtsColumn>();
        int i2 = 0;
        while (i2 < plainSelect.getSelectItems().size()) {
            SelectItem selectItem = (SelectItem)plainSelect.getSelectItems().get(i2);
            if (selectItem instanceof SelectExpressionItem) {
                Alias alias;
                SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
                Expression expression2 = selectExpressionItem.getExpression();
                XdtsColumn selectColumn = new XdtsColumn();
                selectColumn.elemet = new XdtsElemet();
                selectColumn.elemet.template = selectColumn.elemet.orign = expression2.toString().trim();
                if (expression2 instanceof SubSelect) {
                    SubSelect subSelect = (SubSelect)expression2;
                    this.parseSubSelect(subSelect, extractionCondition, parentXdtsSelect, selectColumn.elemet);
                }
                if ((alias = selectExpressionItem.getAlias()) != null) {
                    selectColumn.alias = alias.getName();
                    this.visitColumnAlias(selectExpressionItem, alias, i2);
                }
                selectColumn.order = i2 + 1;
                xdtsSelect.columnList.add(selectColumn);
            } else if (selectItem instanceof AllColumns || selectItem instanceof AllTableColumns) {
                XdtsColumn selectColumn = new XdtsColumn();
                selectColumn.elemet = new XdtsElemet();
                selectColumn.elemet.template = selectColumn.elemet.orign = selectItem.toString().trim();
                selectColumn.order = i2 + 1;
                xdtsSelect.columnList.add(selectColumn);
            } else {
                throw new Exception(selectItem.toString());
            }
            ++i2;
        }
        XdtsControlContext controlContext = XdtsSqlParserUtil.createSelectContext();
        xdtsSelect.controlContextList.add(controlContext);
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem == null) {
            xdtsSelect.from = null;
        } else {
            controlContext = XdtsSqlParserUtil.createFromContext();
            StringBuilder sb = new StringBuilder();
            sb.append(fromItem.toString());
            List joinList = plainSelect.getJoins();
            if (!BcCollectionUtil.isEmpty(joinList)) {
                int i3 = 0;
                while (i3 < joinList.size()) {
                    Join join = (Join)joinList.get(i3);
                    this.visitJoin(join);
                    sb.append("\n " + join.toString());
                    ++i3;
                }
            }
            xdtsSelect.from = new XdtsElemet();
            xdtsSelect.from.template = xdtsSelect.from.orign = sb.toString();
            xdtsSelect.controlContextList.add(controlContext);
            this.parseFrom(fromItem, extractionCondition, xdtsSelect, xdtsSelect.from, null);
        }
        Expression where = plainSelect.getWhere();
        xdtsSelect.whereBase = new XdtsElemet();
        xdtsSelect.whereBase.template = xdtsSelect.whereBase.orign = BcStringUtil.toString(where);
        controlContext = XdtsSqlParserUtil.createWhereContext();
        xdtsSelect.controlContextList.add(controlContext);
        this.parseWhere(where, extractionCondition, parentXdtsSelect, xdtsSelect.whereBase);
        GroupByElement groupByElement = plainSelect.getGroupBy();
        if (groupByElement == null) {
            xdtsSelect.groupBy = null;
        } else {
            ExpressionList expressionList = groupByElement.getGroupByExpressionList();
            List expressionList2 = expressionList.getExpressions();
            StringBuilder sb = new StringBuilder();
            i = 0;
            while (i < expressionList2.size()) {
                expression = (Expression)expressionList2.get(i);
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(expression.toString());
                ++i;
            }
            xdtsSelect.groupBy = sb.toString();
        }
        Expression havingExpression = plainSelect.getHaving();
        xdtsSelect.having = new XdtsElemet();
        xdtsSelect.having.template = xdtsSelect.having.orign = BcStringUtil.toString(havingExpression);
        this.parseWhere(havingExpression, extractionCondition, parentXdtsSelect, xdtsSelect.having);
        controlContext = XdtsSqlParserUtil.createOrderByContext();
        xdtsSelect.controlContextList.add(controlContext);
        List orderByElementList = plainSelect.getOrderByElements();
        xdtsSelect.orderByList = new ArrayList<XdtsOrderBy>();
        if (orderByElementList != null) {
            xdtsOrderBy = new XdtsOrderBy();
            i = 0;
            while (i < orderByElementList.size()) {
                OrderByElement orderByElement = (OrderByElement)orderByElementList.get(i);
                XdtsOrderByElement xdtsOrderByElement = new XdtsOrderByElement();
                xdtsOrderByElement.name = orderByElement.getExpression().toString();
                xdtsOrderByElement.isAscending = orderByElement.isAsc();
                xdtsOrderBy.orderByElementList.add(xdtsOrderByElement);
                ++i;
            }
            xdtsSelect.orderByList.add(xdtsOrderBy);
        }
        if ((xdtsOrderBy = BcCollectionUtil.getFirst(xdtsSelect.orderByList)) != null) {
            controlContext.defaultValue = XdtsSqlConditionUtil.toOrderByString(xdtsOrderBy);
        }
        controlContext = XdtsSqlParserUtil.createRowLimitContext();
        Limit limit = plainSelect.getLimit();
        if (limit != null) {
            expression = limit.getRowCount();
            controlContext.defaultValue = expression.toString();
        }
        xdtsSelect.controlContextList.add(controlContext);
        return xdtsSelect;
    }

    protected void visitTabale(Table table) throws Exception {
        Alias alias = table.getAlias();
        if (alias != null) {
            this.rsmdSupplement.tableAliasMap.put(table.getName().toLowerCase(), alias.getName().toLowerCase());
        }
    }

    protected void visitJoin(Join join) throws Exception {
        FromItem fromItem = join.getRightItem();
        Alias alias = fromItem.getAlias();
        if (alias != null) {
            String aName = this.getName(fromItem.toString());
            this.rsmdSupplement.tableAliasMap.put(aName.toLowerCase(), alias.getName().toLowerCase());
        }
    }

    protected void visitColumnAlias(SelectExpressionItem selectExpressionItem, Alias alias, int columnIndex) throws Exception {
        String columnAlias = this.removeQuotationMark(alias.getName());
        if (this.map != null && this.map.containsKey(columnAlias)) {
            String tmp;
            columnAlias = tmp = this.map.get(columnAlias);
        }
        if (!(selectExpressionItem.getExpression() instanceof Column)) {
            return;
        }
        String key = String.valueOf(columnAlias.toLowerCase()) + "-" + columnIndex;
        this.rsmdSupplement.columnAliasMap.put(key, selectExpressionItem.getExpression().toString());
    }

    protected String getName(String str) throws Exception {
        String[] array = str.split("\\s+");
        return array[0];
    }

    protected String removeQuotationMark(String str) throws Exception {
        if (BcStringUtil.isEmpty(str)) {
            return str;
        }
        if (str.charAt(0) == BcUnicode.quotationMark.char_) {
            if (str.length() == 1) {
                throw new Exception("str=" + str);
            }
            char lastChar = str.charAt(str.length() - 1);
            if (lastChar == BcUnicode.quotationMark.char_) {
                return str.substring(1, str.length() - 1);
            }
            throw new Exception("str=" + str);
        }
        return str;
    }
}

