/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.charset.BcCharsetNames;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcSortUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.httpserver.HtsvArgument;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractWCB;
import jp.co.extreme.module.xsod.common.XsodUtil;
import jp.co.extreme.module.xsod.dao.XsodCategoryDAO;
import jp.co.extreme.module.xsod.dao.XsodMerchandiseDAO;
import jp.co.extreme.module.xsod.model.XsodCategory;
import jp.co.extreme.module.xsod.model.XsodMenuData;
import jp.co.extreme.module.xsod.model.XsodMerchandise;
import jp.co.extreme.module.xsod.model.XsodMerchandisePack;
import jp.co.extreme.module.xsod.model.XsodSignageData;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.XwebUtil;

public class Wbs1SignageWCB
extends Wbs1AbstractWCB {
    public void getSignageData(HtsvArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSession = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            XsodSignageData signageData = this.getSignage_L2(dtsSession);
            ObjectMapper objectMapper = new ObjectMapper();
            String json = objectMapper.writeValueAsString((Object)signageData);
            File tmpDir = new File(AfbApplication.getInstance().toReal("${APP}temp/"));
            File fle = new File(tmpDir, "signage.json");
            BcFileUtil.save(fle, json.getBytes(BcCharsetNames.UTF_8.value));
            WbfwUtil.outputHtml(wcbArg, json);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected XsodSignageData getSignage_L2(DtsSession dtsSession) throws Exception {
        XsodMerchandise merchandise;
        XsodSignageData signageData = new XsodSignageData();
        signageData.merchandisePackList = new ArrayList<XsodMerchandisePack>();
        List<XsodMerchandise> merchandiseList1 = XsodMerchandiseDAO.getInstance().getList(dtsSession, null);
        ArrayList<XsodMerchandise> merchandiseList2 = new ArrayList<XsodMerchandise>();
        int i = 0;
        while (i < merchandiseList1.size()) {
            merchandise = merchandiseList1.get(i);
            if (!BcStringUtil.isEmpty(merchandise.signage)) {
                merchandiseList2.add(merchandise);
            }
            ++i;
        }
        BcSortUtil.sort(merchandiseList2, true, new Object[]{"signage"});
        BcLogUtil.debug("merchandiseList2.size()=" + merchandiseList2.size());
        i = 0;
        while (i < merchandiseList2.size()) {
            merchandise = (XsodMerchandise)merchandiseList2.get(i);
            if (!BcStringUtil.isEmpty(merchandise.signage)) {
                XsodMerchandisePack merchandisePack = new XsodMerchandisePack();
                merchandisePack.merchandise = merchandise;
                merchandisePack.imageUrl = "marchandiseImage?imageId=" + merchandise.imageFileName;
                signageData.merchandisePackList.add(merchandisePack);
            }
            ++i;
        }
        return signageData;
    }

    public void getMenuData(HtsvArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSession = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            XsodMenuData menuData = new XsodMenuData();
            List<XsodMerchandise> merchandiseList = XsodMerchandiseDAO.getInstance().getList(dtsSession, null);
            BcLogUtil.debug("merchandiseList.size()=" + merchandiseList.size());
            int i = 0;
            while (i < merchandiseList.size()) {
                XsodMerchandise merchandse = merchandiseList.get(i);
                XsodMerchandisePack merchandisePack = this.createMerchandisePack(dtsSession, merchandse);
                menuData.merchandiseMap.put(merchandse.code, merchandisePack);
                ++i;
            }
            int setId = 1;
            List<XsodCategory> categoryLisat = XsodCategoryDAO.getInstance().getList(dtsSession, setId, null);
            XsodUtil.setupDataPack(menuData, categoryLisat);
            ObjectMapper objectMapper = new ObjectMapper();
            String json = objectMapper.writeValueAsString((Object)menuData);
            WbfwUtil.outputHtml(wcbArg, json);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected XsodMerchandisePack createMerchandisePack(DtsSession dtsSession, XsodMerchandise item) throws Exception {
        XsodMerchandisePack merchandisePack = new XsodMerchandisePack();
        merchandisePack.merchandise = item;
        return merchandisePack;
    }

    public static enum Method implements WbxPath
    {
        getSignageData("getSignageData"),
        getMenuData("getMenuData");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return Wbs1SignageWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

