/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import java.util.List;
import jp.co.extreme.base.core.BcLangUtil;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcSIUnitUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.httpserver.HtsvArgument;
import jp.co.extreme.httpserver.HtsvRequestParameter;
import jp.co.extreme.httpserver.HtsvUrlParameterMap;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbs1.common.Wbs1Constants;
import jp.co.extreme.module.wbs1.dao.Wbs1AnswerDAO;
import jp.co.extreme.module.wbs1.dao.Wbs1PersonalIdentificationDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Account;
import jp.co.extreme.module.wbs1.model.Wbs1Answer;
import jp.co.extreme.module.wbs1.model.Wbs1PersonalIdentification;
import jp.co.extreme.module.wbs1.model.WbsTempCondition;
import jp.co.extreme.module.wbs1.server.PersonManager;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractDashboardWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1MyPageWCB;
import jp.co.extreme.module.wbs1.wcb.WbsFileUploadFormCreator;
import jp.co.extreme.module.xsys.common.XsysWords;
import jp.co.extreme.module.xsys.validation.XsysValidator;
import jp.co.extreme.module.xweb.common.WbsFiledHtmlCreator;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxFormBuilder;
import jp.co.extreme.module.xweb.common.WbxFormData;
import jp.co.extreme.module.xweb.common.WbxParameterUtil;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.WbxTokenContext;
import jp.co.extreme.module.xweb.common.XwebFileContext;
import jp.co.extreme.module.xweb.common.XwebHtmlBuilder;
import jp.co.extreme.module.xweb.common.XwebIconManager;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.web.javascript.WbfJslUtil;
import jp.co.extreme.web.upload.WebDndUtil;
import jp.co.extreme.web.upload.WebFileCheckUtil;
import jp.co.extreme.web.upload.WebImagePreviewUtil;

public class Wbs1PersonalIdentificationWCB
extends Wbs1AbstractDashboardWCB {
    @Override
    protected StringBuilder createBodyScript(HtsvArgument wcbArg) throws Exception {
        StringBuilder sb = super.createBodyScript(wcbArg);
        sb.append(WebImagePreviewUtil.getScript1());
        int i = 0;
        while (i < 2) {
            String fileIdSuffix = Integer.toString(i + 1);
            sb.append(WebDndUtil.getScript(String.valueOf(WebDndUtil.dndAreaIdPrefix) + fileIdSuffix, String.valueOf(WebDndUtil.inputFileId) + fileIdSuffix, String.valueOf(WebImagePreviewUtil.canvasId) + fileIdSuffix, String.valueOf(WebImagePreviewUtil.canvasParentId) + fileIdSuffix));
            ++i;
        }
        long maxSize = 0xA00000L;
        String msg = String.format("\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\u306f\u6700%S\u3067\u3059\u3002", BcSIUnitUtil.toByteString(maxSize));
        sb.append(WebFileCheckUtil.getScript(maxSize, msg, new String[0]));
        return sb;
    }

    public void form(HtsvArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            this.form_L2(wcbArg, dtsSessionSite);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void form_L2(HtsvArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.form);
        HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
        HtsvUrlParameterMap decryptMap = WbfwUtil.getDecryptMap(requestParameter.map);
        Wbs1PersonalIdentification personalIdentification = null;
        Wbs1Constants.OperationMode operationMode = null;
        if (tokenContext.validationResult == null) {
            long personId = decryptMap.getAsLong(WbxConstants.QueryParam.personId, null);
            PersonManager personManager = PersonManager.getInstance(wcbArg.getSiteContext().getDataSourceName());
            Wbs1Account account = personManager.getAccountByPersonId(personId);
            WbsTempCondition tempCondition = new WbsTempCondition();
            tempCondition.personId = personId;
            personalIdentification = (Wbs1PersonalIdentification)Wbs1PersonalIdentificationDAO.getInstance().getByPersonId(dtsSessionSite, tempCondition);
            if (personalIdentification == null) {
                personalIdentification = new Wbs1PersonalIdentification();
                personalIdentification.personId = personId;
            }
            XwebUtil.putToMap(tokenContext.map, personalIdentification);
            operationMode = BcLangUtil.getEnumByName(Wbs1Constants.OperationMode.class, decryptMap.getAsString(Wbs1Constants.OperationMode.class.getSimpleName()));
            XwebUtil.putToMap(tokenContext.map, Wbs1Constants.OperationMode.class, (Object)operationMode);
        } else {
            personalIdentification = (Wbs1PersonalIdentification)XwebUtil.getMapValue(tokenContext.map, Wbs1PersonalIdentification.class);
            operationMode = (Wbs1Constants.OperationMode)((Object)XwebUtil.getMapValue(tokenContext.map, Wbs1Constants.OperationMode.class));
        }
        BcLogUtil.debug("### operationMode=" + (Object)((Object)operationMode));
        WbxFormData formData = new WbxFormData();
        formData.icon = XwebIconManager.createTag(XwebIconManager.WebIcon.personalIdentification);
        StringBuilder title = new StringBuilder();
        formData.title = XsysWords.getInstance().\u672c\u4eba\u78ba\u8a8d;
        formData.description = "\u904b\u8ee2\u514d\u8a31\u8a3c\u306e\u5834\u5408\u306f\u8868\u3068\u88cf\u306e\u753b\u50cf\u3092\u767b\u9332\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
        InnerFiledHtmlCreator filedHtmlCreator = new InnerFiledHtmlCreator(this.getHtmlBuilder());
        filedHtmlCreator.operationMode = operationMode;
        StringBuilder fileds = new StringBuilder();
        fileds.append(filedHtmlCreator.create(personalIdentification, tokenContext.validationResult));
        fileds.append(this.getHtmlBuilder().br());
        WbsFileUploadFormCreator uploadFormCreator = new WbsFileUploadFormCreator();
        int i = 0;
        while (i < personalIdentification.fileIds.length) {
            XwebFileContext fileContext = XwebUtil.createFileContext(wcbArg, dtsSessionSite, personalIdentification.fileIds[i]);
            String fileIdSuffix = Integer.toString(i + 1);
            String dndArea = WebImagePreviewUtil.temp(this.getHtmlBuilder(), uploadFormCreator, String.valueOf(Wbs1Answer.FieldName.fileIds.name()) + fileIdSuffix, fileIdSuffix, fileContext.href, fileContext.fileName);
            fileds.append(WebImagePreviewUtil.fileBox(this.getHtmlBuilder(), XsysWords.getInstance().\u672c\u4eba\u78ba\u8a8d\u66f8\u985e, dndArea, WebFileCheckUtil.maxSize));
            ++i;
        }
        fileds.append(this.getHtmlBuilder().hidden(WbxConstants.SessionAttributeKey.submitMode.name(), null));
        formData.fileds = fileds.toString();
        StringBuilder controls = new StringBuilder();
        String href = XwebUtil.toRelativePath(wcbArg.getRequest(), Method.submit);
        String onclickAction = WbfJslUtil.submit3(formData.formName, href, WbxConstants.SessionAttributeKey.submitMode.name(), BcWords.getInstance().save);
        controls.append(XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().save, onclickAction));
        controls.append(this.getHtmlBuilder().br());
        controls.append(this.getHtmlBuilder().br());
        onclickAction = WbfJslUtil.submit3(formData.formName, href, WbxConstants.SessionAttributeKey.submitMode.name(), BcWords.getInstance().approve);
        controls.append(XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().approve, onclickAction));
        controls.append(this.getHtmlBuilder().br());
        controls.append(this.getHtmlBuilder().br());
        onclickAction = WbfJslUtil.submit3(formData.formName, href, WbxConstants.SessionAttributeKey.submitMode.name(), BcWords.getInstance().deny);
        controls.append(XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().deny, onclickAction));
        controls.append(this.getHtmlBuilder().br());
        controls.append(this.getHtmlBuilder().br());
        onclickAction = XwebUtil.onclickActionToBack(wcbArg);
        controls.append(XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().cancel, onclickAction));
        controls.append(XwebUtil.createTokenHiddn(this.getHtmlBuilder(), tokenContext));
        formData.controls = controls.toString();
        StringBuilder sb = new StringBuilder();
        WbxFormBuilder formBaseBuilder = new WbxFormBuilder(this.getHtmlBuilder2());
        sb.append(formBaseBuilder.build(formData));
        sb = MdlCreator.getInstance().grid_cell(12, sb);
        sb = MdlCreator.getInstance().grid_portfolio(sb);
        StringBuilder html = this.getBaseHtml(wcbArg);
        html = this.replace(wcbArg, formData.getTitle(), null, html);
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.content.value, sb);
        WbfwUtil.outputHtml(wcbArg, html.toString());
    }

    public void submit(HtsvArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            this.submit_L2(wcbArg, dtsSessionSite);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void submit_L2(HtsvArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.form);
        HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
        BcLogUtil.debug("### requestParameter.map=" + requestParameter.map);
        Wbs1Answer answer = new Wbs1Answer();
        WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, answer);
        String submitMode = requestParameter.map.getAsString(WbxConstants.SessionAttributeKey.submitMode);
        BcLogUtil.debug("### submitMode=" + submitMode);
        XsysValidator validator = XsysValidator.getInstance();
        tokenContext.validationResult = validator.validate(answer);
        List<XwebFileContext> fileContextList = XwebUtil.createFileContextList(wcbArg, dtsSessionSite, this.getLogger());
        int i = 0;
        while (i < fileContextList.size()) {
            XwebFileContext fileContext = fileContextList.get(i);
            String fileSuffix = XwebUtil.getSuffix(fileContext.uploadContext.fieldName, Wbs1Answer.FieldName.fileIds.name());
            int arrayIndex = Integer.parseInt(fileSuffix) - 1;
            answer.fileIds[arrayIndex] = fileContext.fileResource.id;
            ++i;
        }
        if (BcWords.getInstance().approve.equals(submitMode)) {
            answer.setJudgementDatetime(BcTimeUtil.createCalendar());
            answer.setJudgementStatusId(Wbs1Constants.JudgementStatus.approval.id);
        } else if (BcWords.getInstance().approve.equals(submitMode)) {
            answer.setJudgementDatetime(BcTimeUtil.createCalendar());
            answer.setJudgementStatusId(Wbs1Constants.JudgementStatus.denial.id);
        }
        if (tokenContext.validationResult.hasError()) {
            XwebUtil.putToMap(tokenContext.map, answer);
            XwebUtil.inputErrorPreprocessing(tokenContext, requestParameter, tokenContext.validationResult);
            this.form(wcbArg);
            return;
        }
        Wbs1AnswerDAO.getInstance().putEntity(dtsSessionSite, answer);
        dtsSessionSite.commit();
        PersonManager personManager = PersonManager.getInstance(wcbArg.getSiteContext().getDataSourceName());
        personManager.crear(answer.personId);
        String path = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1MyPageWCB.Method.myPage);
        wcbArg.getResponse().sendRedirect(path);
    }

    public void preview(HtsvArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            this.preview_l2(wcbArg, dtsSessionSite);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void preview_l2(HtsvArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.search);
        HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
        String tmpStr = requestParameter.getAsString(WbxConstants.QueryParam.personId.name());
        long personId = BcNumberUtil.parseLong(tmpStr);
        StringBuilder sb = new StringBuilder();
        sb = MdlCreator.getInstance().grid_cell(12, sb);
        sb = MdlCreator.getInstance().grid_portfolio(sb);
        StringBuilder html = this.getBaseHtml(wcbArg);
        html = this.replace(wcbArg, "bbbbbbb", null, html);
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.content.value, sb);
        WbfwUtil.outputHtml(wcbArg, html.toString());
    }

    class InnerFiledHtmlCreator
    extends WbsFiledHtmlCreator {
        Wbs1Constants.OperationMode operationMode;

        public InnerFiledHtmlCreator(HtmlBuilder htmlBuilder) {
            super(htmlBuilder);
        }
    }

    public static enum Method implements WbxPath
    {
        form("personal-identification"),
        submit("personal-identification-submit"),
        preview("personal-identification-preview");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return Wbs1PersonalIdentificationWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

