/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.impt.swg;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.app.common.AfbApplicationContext;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.module.impt.rmo.ImptImportContextRMO;
import jp.co.extreme.module.impt.stub.ImptGeneralStub;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.scf3.client.ScfSqlClientTask;
import jp.co.extreme.scf5.swg.IswgLoadableTablePanel;
import jp.co.extreme.swing.SwgButton;
import jp.co.extreme.swing.SwgTableView;
import jp.co.extreme.swing.SwgTableViewUtil;

public class ImptImportContextListPanel
extends IswgLoadableTablePanel {
    protected SwgButton deleteButton;
    protected SwgButton closeButton;

    public ImptImportContextListPanel() throws Exception {
        this.deleteButton = new SwgButton(BcWords.getInstance().delete, new ImageIcon(AwtImageHelper.getImageAsIcon("cancel_64x64.png")));
        this.closeButton = new SwgButton(BcWords.getInstance().close);
        this.deleteButton.addActionListener(this.actionListener);
        this.tableControlPanel.addControl3(this.deleteButton);
        this.closeButton.addActionListener(this.actionListener);
        this.tableControlPanel.addControl3(this.closeButton);
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ImptImportContextRMO.class.getName());
        rmiReq.setMethodName("importContextList");
        this.doLoad(rmiReq);
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        SwgTableView tableView = this.getTableView();
        BcTableColumnModel tableColumnModel = this.getTableModel().getTableColumnModel();
        if (ev.getSource() == this.deleteButton) {
            List dataIdList = SwgTableViewUtil.getSelectedValueList(tableView, tableColumnModel.getIndexByTableColumnName("impt_import_context.id"), true);
            if (dataIdList.size() > 0) {
                int importContextId = (Integer)dataIdList.get(0);
                if (JOptionPane.showConfirmDialog(this, "\u524a\u9664\u3092\u5b9f\u884c\u3057\u307e\u3059\u304b\uff1f", BcWords.getInstance().confirmation, 0) == 0) {
                    ImptGeneralStub.getInstance().deleteImportContext(importContextId);
                }
            }
        } else if (ev.getSource() == this.closeButton) {
            this.close();
            Container container = this.getParent();
            container.remove(this);
        }
    }

    @Override
    public void started(ScfSqlClientTask sqlClientTask) throws Exception {
        super.started(sqlClientTask);
        this.tableControlPanel.setControlEnabled3(true);
    }

    @Override
    public void loaded(ScfSqlClientTask sqlClientTask, boolean eod) throws Exception {
        super.loaded(sqlClientTask, eod);
        this.deleteButton.setEnabled(false);
    }

    @Override
    protected void tableSelectionChanged(ListSelectionEvent ev) throws Exception {
        super.tableSelectionChanged(ev);
        if (ev.getValueIsAdjusting()) {
            return;
        }
        this.deleteButton.setEnabled(false);
        SwgTableView tableView = this.getTableView();
        int[] rowViewIdxs = tableView.getSelectedRows();
        if (rowViewIdxs.length == 0) {
            return;
        }
        AfbApplication application = AfbApplication.getInstance();
        AfbApplicationContext applicationContext = application.getApplicationContext();
        if (applicationContext.runMode == 1) {
            this.deleteButton.setEnabled(true);
        }
    }
}

