/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.filewatch;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.module.filewatch.ExtWatchKeys;

public class ExtFileChangeWatcher
extends BcLoggableObject {
    private final WatchService watchService;
    private final ExtWatchKeys watchKeys;
    private final List<Callback> callbackList = new ArrayList<Callback>();

    public ExtFileChangeWatcher(Path dirPath, Callback ... cb) {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
            this.watchKeys = new ExtWatchKeys(dirPath, this.watchService);
            this.callbackList.addAll(Arrays.asList(cb));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (WatchService watchService = this.watchService;){
                do {
                    WatchKey key;
                    try {
                        BcLogUtil.debug("take...");
                        key = watchService.take();
                        BcLogUtil.debug("key=" + key);
                    }
                    catch (InterruptedException e) {
                        if (watchService != null) {
                            watchService.close();
                        }
                        return;
                    }
                    this.hundleEvent(key);
                    boolean valid = key.reset();
                    if (!valid) {
                        this.watchKeys.remove(key);
                    }
                    this.watchKeys.sweep();
                } while (!this.watchKeys.isEmpty());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void hundleEvent(WatchKey key) throws IOException {
        for (WatchEvent<?> event : key.pollEvents()) {
            if (event.kind() == StandardWatchEventKinds.OVERFLOW) continue;
            WatchEvent<Path> watchEvent = ExtFileChangeWatcher.cast(event);
            Path path = this.watchKeys.get(key).resolve((Path)watchEvent.context());
            if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
                if (event.kind() != StandardWatchEventKinds.ENTRY_CREATE) continue;
                this.watchKeys.register(path);
                continue;
            }
            if (!Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS)) continue;
            for (Callback cb : this.callbackList) {
                cb.onCall(path, watchEvent);
            }
        }
    }

    private static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    public static interface Callback {
        public void onCall(Path var1, WatchEvent<Path> var2);
    }
}

