/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.httpserver;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.httpserver.HtsvSiteContext;
import jp.co.extreme.httpserver.session.HtsvSessionManager;
import jp.co.extreme.httpserver.session.HtsvSessionManagerImpl;
import jp.co.extreme.module.wbfw.servlet.WbfwMainServlet;
import jp.co.extreme.scf8.cluster.common.KscfClusterEventHandler;
import jp.co.extreme.scf8.cluster.common.KscfClusterNode;
import org.w3c.dom.Document;

public class HtsvContainer
extends BcLoggableObject
implements KscfClusterEventHandler {
    protected Document webConfigDom;
    public HtsvSiteContext siteContextDefault;
    public Map<Integer, HtsvSiteContext> siteIdMap = new HashMap<Integer, HtsvSiteContext>();
    public Map<String, HtsvSiteContext> serverNameMap = new TreeMap<String, HtsvSiteContext>();
    public int sessionManagerNo;
    protected HtsvSessionManager httpSessionManager;
    public WbfwMainServlet mainServlet;

    public void startService() throws Exception {
        this.getLogger().info("HtsvContainer is starting...");
        HtsvSessionManagerImpl sessionManager = new HtsvSessionManagerImpl();
        this.setHttpSessionManager(sessionManager);
        sessionManager.startSesionLifeCheck();
        this.getLogger().info("      manager no : " + this.sessionManagerNo);
        this.getLogger().info("  sessionTimeout : " + this.getSiteContextDefault().sessionTimeout);
        this.getLogger().info(" ");
    }

    public void endService() {
        this.getLogger().info("HtsvContainer is stopping...");
        if (this.httpSessionManager != null) {
            try {
                this.httpSessionManager.close();
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
    }

    public HtsvSessionManager getHttpSessionManager() {
        return this.httpSessionManager;
    }

    public void setHttpSessionManager(HtsvSessionManager httpSessionManager) {
        this.httpSessionManager = httpSessionManager;
    }

    public HtsvSiteContext getSiteContextDefault() {
        return this.siteContextDefault;
    }

    @Override
    public void nodeRemoved(KscfClusterNode clusterNode) {
        this.getLogger().info("FwWebContainer.nodeRemoved:clusterNode.id=" + clusterNode.id + " type=" + clusterNode.type);
        if (BcStringUtil.isEmpty(clusterNode.type)) {
            return;
        }
        if (clusterNode.type.indexOf("W") <= 0) {
            return;
        }
    }
}

