/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.util;

import java.awt.Image;
import java.awt.image.BufferedImage;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.image.WritableImage;
import javafx.stage.Modality;
import javafx.stage.Window;
import jp.co.extreme.awt.AwtImageUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcExceptionUtil;
import jp.co.extreme.fx.util.FxOptionPaneWork;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.swing.SwgOptionPane;

public class FxOptionPane {
    public static final int DEFAULT_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int CLOSED_OPTION = -1;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;

    public static int showOptionDialog(Window ownerWindow, Object message, String title, int optionType, int messageType, javafx.scene.image.Image image, Object[] options, Object initialValue) {
        try {
            FxOptionPaneWork optionPaneWork = new FxOptionPaneWork();
            optionPaneWork.optionType = optionType;
            optionPaneWork.messageType = messageType;
            optionPaneWork.textArea.setText(message.toString());
            optionPaneWork.image = image;
            optionPaneWork.stage.setTitle(title);
            if (ownerWindow != null) {
                optionPaneWork.stage.initModality(Modality.WINDOW_MODAL);
                optionPaneWork.stage.initOwner(ownerWindow);
            }
            optionPaneWork.build();
            optionPaneWork.stage.showAndWait();
            return optionPaneWork.selectetOption;
        }
        catch (Exception ex) {
            BcExceptionUtil.getExceptionHandler().handleException(ex, FxOptionPane.class);
            return -1;
        }
    }

    public static void showMessageDialog(Window ownerWindow, Object message, String title, int messageType, javafx.scene.image.Image image) {
        FxOptionPane.showOptionDialog(ownerWindow, message, title, -1, messageType, image, null, null);
    }

    public static void showMessageDialog(Window ownerWindow, Object message, String title, int messageType) {
        javafx.scene.image.Image image = null;
        try {
            image = FxOptionPane.getImageByMessageType(messageType);
        }
        catch (Exception ex) {
            BcExceptionUtil.getExceptionHandler().handleException(ex, FxOptionPane.class);
        }
        FxOptionPane.showMessageDialog(ownerWindow, message, title, messageType, image);
    }

    public static void showMessageDialog(Node baseNode, Object message, String title, int messageType) {
        Window ownerWindow = FxUtil.getWindow(baseNode);
        FxOptionPane.showMessageDialog(ownerWindow, message, title, messageType);
    }

    public static void showMessageDialog(Object message, String title, int messageType) {
        Window ownerWindow = null;
        FxOptionPane.showMessageDialog(ownerWindow, message, title, messageType);
    }

    public static int showConfirmDialog(Window ownerWindow, Object message, String title, int messageType, javafx.scene.image.Image image) {
        try {
            FxOptionPaneWork optionPaneWork = new FxOptionPaneWork();
            optionPaneWork.optionType = 0;
            optionPaneWork.messageType = messageType;
            optionPaneWork.textArea.setText(message.toString());
            optionPaneWork.image = image;
            optionPaneWork.stage.setTitle(title);
            if (ownerWindow != null) {
                optionPaneWork.stage.initModality(Modality.WINDOW_MODAL);
                optionPaneWork.stage.initOwner(ownerWindow);
            }
            optionPaneWork.build();
            optionPaneWork.stage.showAndWait();
            return optionPaneWork.selectetOption;
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            return -1;
        }
    }

    public static int showConfirmDialog(Window ownerWindow, Object message, String title, int messageType) {
        javafx.scene.image.Image image = null;
        try {
            image = FxOptionPane.getImageByMessageType(messageType);
        }
        catch (Exception ex) {
            BcExceptionUtil.getExceptionHandler().handleException(ex, FxOptionPane.class);
        }
        return FxOptionPane.showConfirmDialog(ownerWindow, message, title, messageType, image);
    }

    public static int showConfirmDialog(Node baseNode, Object message, String title, int messageType) {
        Window ownerWindow = FxUtil.getWindow(baseNode);
        return FxOptionPane.showConfirmDialog(ownerWindow, message, title, messageType);
    }

    public static int showConfirmDialog(Object message, String title, int messageType) {
        Window ownerWindow = null;
        return FxOptionPane.showConfirmDialog(ownerWindow, message, title, messageType);
    }

    public static javafx.scene.image.Image getImageByMessageType(int messageType) throws Exception {
        WritableImage image = null;
        Image awtImage = SwgOptionPane.getImage(messageType);
        if (awtImage != null) {
            image = SwingFXUtils.toFXImage((BufferedImage)AwtImageUtil.toBufferedImage(awtImage), null);
        }
        return image;
    }
}

