/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.international;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.image.Image;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcISO;

public class FxxFlagImageHelper {
    private static Map<String, Image> imageMap = new HashMap<String, Image>();
    private static Map<String, String> langMap;

    private FxxFlagImageHelper() throws Exception {
    }

    public static Image getImage(String fileName) throws Exception {
        Image image = imageMap.get(fileName);
        if (image != null) {
            return image;
        }
        String filePath = "resources/shiny/" + fileName;
        InputStream is = FxxFlagImageHelper.class.getResourceAsStream(filePath);
        if (is == null) {
            BcLogUtil.warning("Not found. filePath=" + filePath);
            return null;
        }
        image = new Image(is);
        imageMap.put(fileName, image);
        return image;
    }

    public static Image getImageByIsoCode(String iso3166Alpha2) throws Exception {
        String fileName = String.valueOf(iso3166Alpha2) + ".png";
        Image image = FxxFlagImageHelper.getImage(fileName);
        return image;
    }

    public static Image getImageByLangCode(String iso639Code) throws Exception {
        if (langMap == null) {
            langMap = new HashMap<String, String>();
            langMap.put(BcISO.ISO_639.English.code, BcISO.ISO_3166_1.UnitedStates.alpha2);
            langMap.put(BcISO.ISO_639.Japanese.code, BcISO.ISO_3166_1.Japan.alpha2);
            langMap.put(BcISO.ISO_639.Chinese.code, BcISO.ISO_3166_1.China.alpha2);
            langMap.put(BcISO.ISO_639.Korean.code, BcISO.ISO_3166_1.Korea.alpha2);
        }
        String iso3166Alpha2 = langMap.get(iso639Code);
        return FxxFlagImageHelper.getImageByIsoCode(iso3166Alpha2);
    }
}

