/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.datechooser;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import jp.co.extreme.fx.datechooser.FxDateChooser;

public class FxDateChooserSkin
extends SkinBase<FxDateChooser> {
    private final Date date;
    private final Label month;
    private final BorderPane content;
    final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMMM yyyy");
    FxDateChooser dateChooser;

    public FxDateChooserSkin(FxDateChooser dateChooser) {
        super((Control)dateChooser);
        this.dateChooser = dateChooser;
        this.date = dateChooser.getDate();
        final DatePickerPane calendarPane = new DatePickerPane(this.date);
        this.month = new Label(this.simpleDateFormat.format(calendarPane.getShownMonth()));
        HBox hbox = new HBox();
        Button yearBack = new Button("<<");
        yearBack.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                calendarPane.forward(-12);
            }
        });
        Button monthBack = new Button("<");
        monthBack.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                calendarPane.forward(-1);
            }
        });
        Button monthForward = new Button(">");
        monthForward.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                calendarPane.forward(1);
            }
        });
        Button yearForward = new Button(">>");
        yearForward.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                calendarPane.forward(12);
            }
        });
        HBox.setHgrow((Node)this.month, (Priority)Priority.ALWAYS);
        this.month.setMaxWidth(Double.MAX_VALUE);
        this.month.setAlignment(Pos.CENTER);
        hbox.getChildren().addAll((Object[])new Node[]{yearBack, monthBack, this.month, monthForward, yearForward});
        this.content = new BorderPane();
        this.getChildren().add((Object)this.content);
        this.content.setTop((Node)hbox);
        this.content.setCenter((Node)calendarPane);
    }

    private static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The dates must not be null");
        }
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    private static boolean isToday(Calendar cal) {
        return FxDateChooserSkin.isSameDay(cal, Calendar.getInstance());
    }

    private static class CalendarCell
    extends StackPane {
        private final Date date;

        public CalendarCell(Date day, String text) {
            this.date = day;
            Label label = new Label(text);
            this.getChildren().add((Object)label);
        }

        public Date getDate() {
            return this.date;
        }
    }

    class DatePickerPane
    extends Region {
        private final Date selectedDate;
        private final Calendar cal;
        private CalendarCell selectedDayCell;
        private final SimpleDateFormat sdf = new SimpleDateFormat("d");
        private final CalendarCell woyCell = new CalendarCell(new Date(), "");
        private int rows;
        private int columns;

        public DatePickerPane(Date date) {
            this.setPrefSize(300.0, 300.0);
            this.woyCell.getStyleClass().add((Object)"week-of-year-cell");
            this.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
            this.columns = 7;
            this.rows = 5;
            this.cal = Calendar.getInstance();
            Date helperDate = new Date(date.getTime());
            this.cal.setTime(helperDate);
            this.selectedDate = date;
            this.refresh();
        }

        public void forward(int i) {
            this.cal.add(2, i);
            FxDateChooserSkin.this.month.setText(FxDateChooserSkin.this.simpleDateFormat.format(this.cal.getTime()));
            this.refresh();
        }

        private void refresh() {
            super.getChildren().clear();
            this.rows = 5;
            Date copy = new Date(this.cal.getTime().getTime());
            super.getChildren().add((Object)this.woyCell);
            DateFormatSymbols symbols = new DateFormatSymbols();
            String[] dayNames = symbols.getShortWeekdays();
            int i = 1;
            while (i < 8) {
                CalendarCell calendarCell = new CalendarCell(this.cal.getTime(), dayNames[i]);
                calendarCell.getStyleClass().add((Object)"weekday-cell");
                super.getChildren().add((Object)calendarCell);
                ++i;
            }
            this.cal.set(5, 1);
            final int month = this.cal.get(2);
            int weekday = this.cal.get(7);
            if (weekday != 1) {
                Calendar check = Calendar.getInstance();
                check.setTime(new Date(this.cal.getTime().getTime()));
                int lastDate = check.getActualMaximum(5);
                check.set(5, lastDate);
                if (lastDate + weekday > 36) {
                    this.rows = 6;
                }
                this.cal.add(5, -7);
            }
            this.cal.set(7, 1);
            Calendar testSelected = Calendar.getInstance();
            testSelected.setTime(this.selectedDate);
            int i2 = 0;
            while (i2 < this.rows) {
                CalendarCell calendarCell = new CalendarCell(this.cal.getTime(), "" + this.cal.get(3));
                calendarCell.getStyleClass().add((Object)"week-of-year-cell");
                super.getChildren().add((Object)calendarCell);
                int j = 0;
                while (j < this.columns) {
                    String formatted = this.sdf.format(this.cal.getTime());
                    final CalendarCell dayCell = new CalendarCell(this.cal.getTime(), formatted);
                    dayCell.getStyleClass().add((Object)"calendar-cell");
                    if (this.cal.get(2) != month) {
                        dayCell.getStyleClass().add((Object)"calendar-cell-inactive");
                    } else {
                        if (FxDateChooserSkin.isSameDay(testSelected, this.cal)) {
                            dayCell.getStyleClass().add((Object)"calendar-cell-selected");
                            this.selectedDayCell = dayCell;
                        }
                        if (FxDateChooserSkin.isToday(this.cal)) {
                            dayCell.getStyleClass().add((Object)"calendar-cell-today");
                        }
                    }
                    dayCell.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                        public void handle(MouseEvent ev) {
                            if (DatePickerPane.this.selectedDayCell != null) {
                                DatePickerPane.this.selectedDayCell.getStyleClass().remove((Object)"calendar-cell-selected");
                            }
                            DatePickerPane.this.selectedDate.setTime(dayCell.getDate().getTime());
                            dayCell.getStyleClass().add((Object)"calendar-cell-selected");
                            DatePickerPane.this.selectedDayCell = dayCell;
                            Calendar checkMonth = Calendar.getInstance();
                            checkMonth.setTime(dayCell.getDate());
                            if (checkMonth.get(2) != month) {
                                DatePickerPane.this.forward(checkMonth.get(2) - month);
                            }
                            if (ev.getButton().equals((Object)MouseButton.PRIMARY) && ev.getClickCount() == 2) {
                                ((DatePickerPane)DatePickerPane.this).FxDateChooserSkin.this.dateChooser.selected(DatePickerPane.this.selectedDate);
                            }
                        }
                    });
                    dayCell.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

                        public void handle(MouseEvent e) {
                            dayCell.setScaleX(1.1);
                            dayCell.setScaleY(1.1);
                        }
                    });
                    dayCell.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

                        public void handle(MouseEvent e) {
                            dayCell.setScaleX(1.0);
                            dayCell.setScaleY(1.0);
                        }
                    });
                    super.getChildren().add((Object)dayCell);
                    this.cal.add(5, 1);
                    ++j;
                }
                ++i2;
            }
            this.cal.setTime(copy);
        }

        protected ObservableList<Node> getChildren() {
            return FXCollections.unmodifiableObservableList((ObservableList)super.getChildren());
        }

        public Date getShownMonth() {
            return this.cal.getTime();
        }

        protected void layoutChildren() {
            ObservableList<Node> children = this.getChildren();
            double width = this.getWidth();
            double height = this.getHeight();
            double cellWidth = width / (double)(this.columns + 1);
            double cellHeight = height / (double)(this.rows + 1);
            int i = 0;
            while (i < this.rows + 1) {
                int j = 0;
                while (j < this.columns + 1) {
                    if (children.size() <= i * (this.columns + 1) + j) break;
                    Node get = (Node)children.get(i * (this.columns + 1) + j);
                    this.layoutInArea(get, (double)j * cellWidth, (double)i * cellHeight, cellWidth, cellHeight, 0.0, HPos.LEFT, VPos.TOP);
                    ++j;
                }
                ++i;
            }
        }
    }
}

