/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.datasource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.datasource.DtsConnectionManager;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.datasource.util.DtsWordManagerImpl;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.context.SqlContext;

public class DtsSessionFactory
extends BcLoggableObject
implements AutoCloseable {
    private DtsConnectionManager connectionManager;
    private List<DtsSession> sessionList;
    private String name;
    public DtsWordManager wordManager = new DtsWordManagerImpl();
    public Map<String, Map<String, MmdField>> mmdFieldMap = new HashMap<String, Map<String, MmdField>>();

    public DtsSessionFactory(String name, DtsConnectionManager connectionManager) {
        this.name = name;
        this.connectionManager = connectionManager;
        this.setLogger(connectionManager.getLogger());
        this.sessionList = new ArrayList<DtsSession>();
    }

    public String getName() {
        return this.name;
    }

    public DtsConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public List<DtsSession> getSessionList() {
        return this.sessionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DtsSession createSession(Object owner) throws Exception {
        DtsSession dtsSession = new DtsSession(this);
        dtsSession.setLogger(this.getLogger());
        dtsSession.owner = owner;
        if (this.connectionManager != null) {
            dtsSession.setConnectionManager(this.connectionManager);
            SqlConnection sqlConn = dtsSession.getConnection();
            SqlContext sqlContext = sqlConn.getSqlContext();
            dtsSession.setSqlContext(sqlContext);
        }
        List<DtsSession> list = this.sessionList;
        synchronized (list) {
            this.sessionList.add(dtsSession);
        }
        return dtsSession;
    }

    @Override
    public void close() throws Exception {
        if (this.connectionManager != null) {
            this.connectionManager.destruct();
            this.connectionManager = null;
        }
        if (this.sessionList != null) {
            this.sessionList.clear();
            this.sessionList = null;
        }
    }
}

