/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.mmd;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdIndex;
import jp.co.extreme.base.mmd.MmdIndexElement;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcHtmlConverter;
import jp.co.extreme.base.util.BcObjectConvertor;
import jp.co.extreme.base.util.BcReflectUtil;
import jp.co.extreme.base.util.BcRegexUtil;

public final class MmdUtil {
    public static final int AM_field = 1;
    public static final int AM_method = 2;
    public static final int AM_both = 3;
    public static final int DECIMAL_DIGITS_DEFAULT = -1;
    public static final int SHIFT_DEFAULT = 0;
    public static final int columnCount_DEFAULT = -1;
    public static final char delimiter = '.';
    static final int dummyDate = 20000101;
    protected static BcHtmlConverter htmlConverter = new BcHtmlConverter();

    private MmdUtil() {
    }

    public static int toSqlTypeId(Class clazz) {
        if (clazz == null) {
            return 0;
        }
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE == clazz) {
            return -6;
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE == clazz) {
            return 5;
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE == clazz) {
            return 4;
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE == clazz) {
            return -5;
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE == clazz) {
            return 6;
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE == clazz) {
            return 8;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return 2;
        }
        if (Character.class.isAssignableFrom(clazz) || Character.TYPE == clazz) {
            return 1;
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return 12;
        }
        if (Calendar.class.isAssignableFrom(clazz) || Timestamp.class.isAssignableFrom(clazz)) {
            return 93;
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return 92;
        }
        if (java.util.Date.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz)) {
            return 91;
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE == clazz) {
            return 16;
        }
        if (byte[].class == clazz) {
            return -2;
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            return 2004;
        }
        if (Clob.class.isAssignableFrom(clazz)) {
            return 2005;
        }
        if (Array.class.isAssignableFrom(clazz)) {
            return 2003;
        }
        if (Struct.class.isAssignableFrom(clazz)) {
            return 2002;
        }
        if (Ref.class.isAssignableFrom(clazz)) {
            return 2006;
        }
        return 2000;
    }

    public static Object getValue(MmdField mmdField, Object entity) throws Exception {
        Object value = null;
        int accessMode = 3;
        switch (accessMode) {
            case 1: {
                value = BcReflectUtil.getFieldValue(mmdField.fieldName, entity);
                break;
            }
            case 2: {
                value = BcReflectUtil.invoke(mmdField.fieldName, entity);
                break;
            }
            case 3: {
                try {
                    value = BcReflectUtil.getFieldValue(mmdField.fieldName, entity);
                    break;
                }
                catch (IllegalAccessException ex) {
                    String methodName = BcReflectUtil.toGetterMethod(mmdField.fieldName);
                    value = BcReflectUtil.invoke(methodName, entity);
                    break;
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
        }
        return value;
    }

    public static void setValue(MmdField mmdField, Object entity, Object value) throws Exception {
        int accessMode = 3;
        switch (accessMode) {
            case 1: {
                BcReflectUtil.setFieldValue(mmdField.fieldName, entity, value);
                break;
            }
            case 2: {
                MmdUtil.invokeSetterMethod(BcReflectUtil.toGetterMethod(mmdField.fieldName), mmdField.dataClass, entity, value);
                break;
            }
            case 3: {
                try {
                    BcReflectUtil.setFieldValue(mmdField.fieldName, entity, value);
                    break;
                }
                catch (IllegalAccessException ex) {
                    BcLogUtil.error(ex);
                    break;
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
        }
    }

    public static void invokeSetterMethod(String methodName, Class parameterType, Object entity, Object value) throws Exception {
        Class<?> clazz = entity.getClass();
        Class[] parameterTypes = new Class[]{parameterType};
        Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
        Object[] parameters = new Object[]{value};
        method.invoke(entity, parameters);
    }

    public static String createTableColumnName(String tableName, String columnName, boolean toLowerCase) {
        StringBuilder sb = new StringBuilder();
        if (!BcStringUtil.isEmpty(tableName)) {
            sb.append(tableName);
        }
        if (!BcStringUtil.isEmpty(columnName)) {
            if (!BcStringUtil.isEmpty(tableName)) {
                sb.append('.');
            }
            sb.append(columnName);
        }
        if (toLowerCase) {
            return sb.toString().toLowerCase();
        }
        return sb.toString();
    }

    public static String createTableColumnName(String tableName, String columnName) {
        return MmdUtil.createTableColumnName(tableName, columnName, false);
    }

    public static String[] splitTableColumnName(String \uff54ableColumnName) {
        String[] strArray = BcStringUtil.split(\uff54ableColumnName, BcRegexUtil.escapEncode(String.valueOf('.')));
        return strArray;
    }

    public static List<String> splitTableColumnNameAsList(String \uff54ableColumnName) {
        String[] strArray = MmdUtil.splitTableColumnName(\uff54ableColumnName);
        return Arrays.asList(strArray);
    }

    public static int getHorizonalAlignment(Class dataClass) {
        if (dataClass == null) {
            return 2;
        }
        if (Number.class.isAssignableFrom(dataClass)) {
            return 4;
        }
        if (Calendar.class.isAssignableFrom(dataClass) || java.util.Date.class.isAssignableFrom(dataClass)) {
            return 0;
        }
        if (Boolean.class.isAssignableFrom(dataClass)) {
            return 0;
        }
        return 2;
    }

    public static int getHorizonalAlignment(MmdField mmdField) {
        if (mmdField.fieldDisplay.horizonalAlignment >= 0) {
            return mmdField.fieldDisplay.horizonalAlignment;
        }
        if (mmdField.fieldDisplay.displayClass != null) {
            return MmdUtil.getHorizonalAlignment(mmdField.fieldDisplay.displayClass);
        }
        return MmdUtil.getHorizonalAlignment(mmdField.dataClass);
    }

    public static List<String> toColumnNameList(MmdModel mmdModel) throws Exception {
        ArrayList<String> columnNameList = new ArrayList<String>();
        int i = 0;
        while (i < mmdModel.getFieldCount()) {
            MmdField mmdField = mmdModel.getField(i);
            columnNameList.add(mmdField.columnName);
            ++i;
        }
        return columnNameList;
    }

    public static List<String> toTableColumnNameList(MmdModel mmdModel) throws Exception {
        ArrayList<String> tableColumnNameList = new ArrayList<String>();
        int i = 0;
        while (i < mmdModel.getFieldCount()) {
            MmdField mmdField = mmdModel.getField(i);
            tableColumnNameList.add(mmdField.tableColumnName);
            ++i;
        }
        return tableColumnNameList;
    }

    public static String toSting(Object value, MmdField mmdField) throws Exception {
        if (mmdField == null) {
            return BcStringUtil.toString(value);
        }
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        String resValue = null;
        if (mmdField.fieldDisplay.displayClass != null) {
            if (Integer.class.isAssignableFrom(valueClass)) {
                resValue = MmdUtil.intergerToDateTime((Integer)value, mmdField);
            } else if (Short.class.isAssignableFrom(valueClass)) {
                resValue = MmdUtil.shortToTime((Short)value, mmdField);
            }
        }
        if (resValue != null) {
            return resValue;
        }
        if (Number.class.isAssignableFrom(valueClass)) {
            Number number = (Number)value;
            resValue = MmdUtil.numberToSting(number, mmdField);
        } else {
            resValue = CharSequence.class.isAssignableFrom(valueClass) ? htmlConverter.toPlain(value.toString(), false).toString() : (mmdField != null ? (String)BcObjectConvertor.getInstance().convert(value, String.class, mmdField.fieldDisplay.formatStr, Locale.getDefault()) : value.toString());
        }
        return resValue;
    }

    public static String numberToSting(Number number, MmdField mmdField) throws Exception {
        BigDecimal bigDec = null;
        bigDec = BigDecimal.class.isAssignableFrom(number.getClass()) ? (BigDecimal)number : new BigDecimal(number.toString());
        if (mmdField.fieldDisplay.shift > 0) {
            bigDec = bigDec.movePointLeft(mmdField.fieldDisplay.shift);
        } else if (mmdField.fieldDisplay.shift < 0) {
            bigDec = bigDec.movePointRight(mmdField.fieldDisplay.shift);
        }
        if (mmdField.decimalDigit >= 0) {
            RoundingMode roundingMode = RoundingMode.HALF_UP;
            if (mmdField.fieldDisplay.roundingMode >= 0) {
                roundingMode = RoundingMode.valueOf(mmdField.fieldDisplay.roundingMode);
            }
            bigDec = bigDec.setScale(mmdField.decimalDigit, roundingMode);
        }
        String resValue = null;
        if (mmdField.fieldDisplay.format == null && !BcStringUtil.isEmpty(mmdField.fieldDisplay.formatStr)) {
            mmdField.fieldDisplay.format = new DecimalFormat(mmdField.fieldDisplay.formatStr);
        }
        resValue = mmdField.fieldDisplay.format == null ? bigDec.toString() : (bigDec.scale() != 0 ? mmdField.fieldDisplay.format.format(bigDec.doubleValue()) : mmdField.fieldDisplay.format.format(bigDec.longValue()));
        return resValue;
    }

    public static String intergerToDateTime(int value, MmdField mmdField) throws Exception {
        String resValue = null;
        if (Time.class.isAssignableFrom(mmdField.fieldDisplay.displayClass)) {
            Calendar calendar = BcTimeUtil.toCalendar(20000101, value);
            resValue = BcTimeUtil.toString(calendar, mmdField.fieldDisplay.formatStr);
        } else if (java.util.Date.class.isAssignableFrom(mmdField.fieldDisplay.displayClass)) {
            if (value == 99999999) {
                resValue = BcStringUtil.equals(mmdField.fieldDisplay.formatStr, "yyyy/MM/dd") ? "9999/99/99" : Integer.toString(value);
            } else {
                Calendar calendar = BcTimeUtil.toCalendar(value);
                resValue = BcTimeUtil.toString(calendar, mmdField.fieldDisplay.formatStr);
            }
        }
        return resValue;
    }

    public static String shortToTime(short value, MmdField mmdField) throws Exception {
        String resValue = null;
        if (Time.class.isAssignableFrom(mmdField.fieldDisplay.displayClass)) {
            Calendar calendar = BcTimeUtil.toCalendar(20000101, value);
            resValue = BcTimeUtil.toString(calendar, mmdField.fieldDisplay.formatStr);
        }
        return resValue;
    }

    public static void setDecimalDigits(MmdField mmdField, int decimalDigits) throws Exception {
        if (mmdField.decimalDigit <= -1) {
            mmdField.decimalDigit = decimalDigits;
        }
    }

    public static MmdField createMmdField(Field field) throws Exception {
        MmdField mmdField = new MmdField();
        mmdField.fieldName = field.getName();
        mmdField.dataClass = field.getType();
        mmdField.sqlTypeId = MmdUtil.toSqlTypeId(field.getType());
        mmdField.remarks = null;
        return mmdField;
    }

    public static MmdField createMmdField(String tableColumnName, Class displayClass, String formatStr, int decimalDigits, int columnCount, Map valueMap, int horizonalAlignment, int shift) throws Exception {
        MmdField mmdField = new MmdField();
        mmdField.tableColumnName = tableColumnName.toLowerCase();
        mmdField.fieldDisplay.displayClass = displayClass;
        if (mmdField.fieldDisplay.displayClass != null) {
            mmdField.fieldDisplay.displayClassName = mmdField.fieldDisplay.displayClass.getName();
        }
        MmdUtil.setDecimalDigits(mmdField, decimalDigits);
        mmdField.fieldDisplay.formatStr = formatStr;
        mmdField.columnCount = columnCount;
        mmdField.valueMap = valueMap;
        if (horizonalAlignment >= 0) {
            mmdField.fieldDisplay.horizonalAlignment = horizonalAlignment;
        }
        mmdField.fieldDisplay.shift = shift;
        return mmdField;
    }

    public static List<Field> createFieldList(Class clazz) throws Exception {
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (Modifier.isPublic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers())) {
                fieldList.add(field);
            }
            ++i;
        }
        return fieldList;
    }

    public static List<Field> createFieldListWithSuper(Class clazz) throws Exception {
        List<Class> classList = BcReflectUtil.createSuperclassList(clazz);
        ArrayList<Field> fieldList = new ArrayList<Field>();
        int i = 0;
        while (i < classList.size()) {
            Class clazz2 = classList.get(i);
            fieldList.addAll(MmdUtil.createFieldList(clazz2));
            ++i;
        }
        return fieldList;
    }

    public static MmdModel createMmdModel(Object entity) throws Exception {
        Class<?> entityClass = entity.getClass();
        MmdModel mmdModel = new MmdModel();
        mmdModel.javaClassName = entityClass.getName();
        List<Field> fieldList = MmdUtil.createFieldListWithSuper(entityClass);
        int i = 0;
        while (i < fieldList.size()) {
            Field field = fieldList.get(i);
            MmdField mmdField = MmdUtil.createMmdField(field);
            mmdModel.addField(mmdField);
            ++i;
        }
        return mmdModel;
    }

    public static MmdModel toLower(MmdModel mmdModel) throws Exception {
        MmdModel mmdModel2 = (MmdModel)mmdModel.clone();
        int i = 0;
        while (i < mmdModel2.getFieldCount()) {
            MmdField mmdField = mmdModel2.getField(i);
            mmdField.columnName = BcStringUtil.toLowerCase(mmdField.columnName);
            mmdField.tableColumnName = BcStringUtil.toLowerCase(mmdField.tableColumnName);
            ++i;
        }
        for (Map.Entry<String, MmdIndex> mapEntry : mmdModel2.indexMap.entrySet()) {
            MmdIndex mmdIndex = mapEntry.getValue();
            mmdIndex.name = BcStringUtil.toLowerCase(mmdIndex.name);
        }
        return mmdModel2;
    }

    public static List<String> toColumnNameList(Collection<MmdIndexElement> indexElementCollection) throws Exception {
        ArrayList<String> columnNameList = new ArrayList<String>();
        for (MmdIndexElement indexElement : indexElementCollection) {
            columnNameList.add(indexElement.columnName);
        }
        return columnNameList;
    }

    public static List<String> createMmdFiledCodeList(MmdField mmdField) {
        TreeMap<Integer, String> codeMap = new TreeMap<Integer, String>();
        if (BcStringUtil.isEmpty(mmdField.columnAlias)) {
            if (BcStringUtil.isEmpty(mmdField.tableAlias)) {
                codeMap.put(3, MmdUtil.createTableColumnName(mmdField.tableName, mmdField.columnName));
            } else {
                codeMap.put(2, MmdUtil.createTableColumnName(mmdField.tableAlias, mmdField.columnName));
            }
        } else {
            codeMap.put(1, MmdUtil.createTableColumnName(null, mmdField.columnAlias));
        }
        ArrayList<String> codeList = new ArrayList<String>();
        for (Map.Entry mapEntry : codeMap.entrySet()) {
            codeList.add((String)mapEntry.getValue());
        }
        return codeList;
    }

    public static String getProvisionalHeaderValue(MmdField mmdField) {
        if (!BcStringUtil.isEmpty(mmdField.fieldDisplay.displayName)) {
            return mmdField.fieldDisplay.displayName;
        }
        if (!BcStringUtil.isEmpty(mmdField.columnAlias)) {
            return mmdField.columnAlias;
        }
        if (!BcCollectionUtil.isEmpty(mmdField.codeList)) {
            return BcCollectionUtil.getFirst(mmdField.codeList);
        }
        if (!BcStringUtil.isEmpty(mmdField.fieldName)) {
            return mmdField.fieldName;
        }
        if (!BcStringUtil.isEmpty(mmdField.columnName)) {
            return mmdField.columnName;
        }
        if (!BcStringUtil.isEmpty(mmdField.tableColumnName)) {
            return mmdField.tableColumnName;
        }
        return null;
    }

    public static String createInfo(MmdModel mmdModel) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("tableName=" + mmdModel.tableName + " fieldCount=" + mmdModel.getFieldCount());
        int i = 0;
        while (i < mmdModel.getFieldCount()) {
            MmdField mmdField = mmdModel.getField(i);
            sb.append(BcRuntimeUtil.lineSeparator);
            sb.append("  " + MmdUtil.createInfo(mmdField, false));
            ++i;
        }
        sb.append(BcRuntimeUtil.lineSeparator);
        return sb.toString();
    }

    public static String createInfo(MmdField mmdField, boolean flag) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (mmdField == null) {
            sb.append("mmdField is null.");
            return sb.toString();
        }
        sb.append("columnName=" + mmdField.columnName);
        sb.append(" tableColumnName=" + mmdField.tableColumnName);
        sb.append(" sqlTypeId=" + mmdField.sqlTypeId);
        JDBCType jdbcType = null;
        try {
            jdbcType = JDBCType.valueOf(mmdField.dataSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
        sb.append(" dataSize=" + mmdField.dataSize + "(" + jdbcType + ")");
        sb.append(" decimalPosition=" + mmdField.decimalDigit);
        sb.append(" ordinalPosition=" + mmdField.ordinalPosition);
        if (flag) {
            sb.append(" columnCount=" + mmdField.columnCount);
            sb.append(" horizonalAlignment=" + mmdField.fieldDisplay.horizonalAlignment);
            sb.append(" verticalAlignment=" + mmdField.fieldDisplay.verticalAlignment);
            sb.append(" formatPattern=" + mmdField.fieldDisplay.format);
            sb.append(" displayName=" + mmdField.fieldDisplay.displayName);
        }
        return sb.toString();
    }

    public static enum Alignment {
        NULL(-1),
        CENTER(0),
        TOP(1),
        LEFT(2),
        BOTTOM(3),
        RIGHT(4);

        public final int id;

        private Alignment(int id) {
            this.id = id;
        }

        public static Alignment getById(int id) {
            Alignment[] alignmentArray = Alignment.values();
            int n = alignmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Alignment alignment = alignmentArray[n2];
                if (alignment.id == id) {
                    return alignment;
                }
                ++n2;
            }
            return null;
        }
    }
}

