/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.assembler.wbs;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.co.extreme.assembler.wbs.TextSummarizeTask;
import jp.co.extreme.assembler.wbs.WbsSentence;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.httpserver.HtsvArgument;
import jp.co.extreme.httpserver.HtsvRequestParameter;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.lib.html.mdc.MdcCreator;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbfw.server.XwebMailHelper;
import jp.co.extreme.module.wbs1.common.Wbs1Words;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractWCB;
import jp.co.extreme.module.xsys.validation.XsysValidator;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;
import jp.co.extreme.module.xweb.common.WbsFiledHtmlCreator;
import jp.co.extreme.module.xweb.common.WbsProgress;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxFormBuilder;
import jp.co.extreme.module.xweb.common.WbxFormData;
import jp.co.extreme.module.xweb.common.WbxParameterUtil;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.WbxTokenContext;
import jp.co.extreme.module.xweb.common.XwebLabelAndInputBuilder;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.nlp.rest.NlpRestHelper;
import jp.co.extreme.nlp.rest.NlpRestRequest;
import jp.co.extreme.nlp.rest.NlpRestResponse;
import jp.co.extreme.web.jquery.progress.JqProgressUtil;
import jp.co.extreme.web.upload.WebProcessUtil;

public class AsemTextSummarizeWCB
extends Wbs1AbstractWCB {
    public void form(HtsvArgument wcbArg) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.search);
        HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
        WbsSentence sentence = null;
        if (tokenContext.validationResult == null) {
            sentence = new WbsSentence();
            sentence.sentence = "\u662f\u306f\u4e16\u9593\u3092\u619a\u304b\u308b\u9060\u616e\u3068\u3044\u3046\u3088\u308a\u3082\u3001\u5176\u65b9\u304c\u79c1\u306b\u3068\u3063\u3066\u81ea\u7136\u3060\u304b\u3089\u3067\u3042\u308b\u3002 \u79c1(\u308f\u305f\u304f\u3057)\u306f\u5176\u4eba\u3092\u5e38\u306b\u5148\u751f\u3068\u547c\u3093\u3067\u3044\u305f\u3002 \u6691\u4e2d\u4f11\u6687\u3092\u5229\u7528\u3057\u3066\u6d77\u6c34\u6d74\u306b\u884c\u3063\u305f\u53cb\u9054\u304b\u3089\u662f\u975e\u6765\u3044\u3068\u3044\u3046\u7aef\u66f8\u3092\u53d7\u53d6\u3063\u305f\u306e\u3067\u3001\u79c1\u306f\u591a\u5c11\u306e\u91d1\u3092\u5de5\u9762\u3057\u3066\u3001\u51fa\u639b\u308b\u4e8b\u306b\u3057\u305f\u3002";
        } else {
            sentence = (WbsSentence)XwebUtil.getMapValue(tokenContext.map, WbsSentence.class);
            this.getLogger().debug("tokenContext.validationResult.hasError()=" + tokenContext.validationResult.hasError());
        }
        WbxFormData formData = new WbxFormData();
        formData.title = Wbs1Words.getInstance().textSummarize.toPlain();
        formData.description = "\u81ea\u7136\u8a00\u8a9e\u51e6\u7406\uff08NLP\uff09\u306b\u3088\u308b\u65e5\u672c\u8a9e\u6587\u7ae0\u306e\u8981\u7d04\u6a5f\u80fd\u3067\u3059\u3002\u5229\u7528\u898f\u7d04\u306b\u540c\u610f\u306e\u3046\u3048\u3001\u3054\u5229\u7528\u304f\u3060\u3055\u3044\u3002";
        StringBuilder fileds = new StringBuilder();
        WbsFiledHtmlCreator filedHtmlCreator = new WbsFiledHtmlCreator(this.getHtmlBuilder());
        fileds.append(filedHtmlCreator.create(sentence, tokenContext.validationResult));
        XwebLabelAndInputBuilder labelAndInputBuilder = new XwebLabelAndInputBuilder();
        String option = "SpaCy:ja_core_news_lg";
        String[] options = new String[]{option};
        fileds.append(labelAndInputBuilder.createSelect("option", false, false, "Option", option, true, null, null, null, options));
        fileds.append((CharSequence)this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
        String tmp = labelAndInputBuilder.createTextArea("conveted", 80, 10, false, true, BcWords.getInstance().result, sentence.conveted, false, "helperText", null, null);
        fileds.append(JqProgressUtil.getInstance().createResultDiv(this.getHtmlBuilder(), tmp));
        fileds.append(JqProgressUtil.getInstance().createProgressTags(this.getHtmlBuilder()));
        formData.fileds = fileds.toString();
        StringBuilder controls = new StringBuilder();
        String onclick = "tmp_start2();";
        String executeButton = MdcCreator.getInstance().button(HtmlConstants.HtmlButtonType.button, BcWords.getInstance().execute, onclick, null, WbxConstants.ElementId.executeButton.id, null, true);
        controls.append(executeButton);
        controls.append(XwebUtil.createTokenHiddn(this.getHtmlBuilder(), tokenContext));
        formData.controls = controls.toString();
        WbxFormBuilder formBuilder = new WbxFormBuilder(this.getHtmlBuilder2());
        StringBuilder sb = new StringBuilder();
        sb.append(formBuilder.build(formData));
        sb = MdlCreator.getInstance().grid_cell(12, sb);
        sb = MdlCreator.getInstance().grid_portfolio(sb);
        ArrayList<String> bodyScriptList = new ArrayList<String>();
        String urlBase = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.getProgress)) + "?" + (Object)((Object)WbxConstants.SessionAttributeKey.token) + "=";
        String script = JqProgressUtil.getInstance().getScript(urlBase);
        bodyScriptList.add(script);
        String param1 = WbfwUtil.createParameter((Enum)WbxConstants.SessionAttributeKey.token, XwebUtil.createTokenString(tokenContext));
        String submitUrl = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.submit)) + WbfwUtil.createUrlQuery(param1);
        bodyScriptList.add(WebProcessUtil.getScript1(submitUrl));
        StringBuilder html = this.getBaseHtml(wcbArg);
        String metaDescription = "\u81ea\u7136\u8a00\u8a9e\u51e6\u7406\uff08NLP\uff09\u306b\u3088\u308b\u65e5\u672c\u8a9e\u6587\u7ae0\u306e\u8981\u7d04\u6a5f\u80fd\u3067\u3059\u3002";
        html = this.replace(wcbArg, formData.getTitle(), metaDescription, html, null, bodyScriptList);
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.content.value, sb);
        WbfwUtil.outputHtml(wcbArg, html.toString());
    }

    public void submit(HtsvArgument wcbArg) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.search);
        HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
        WbsSentence sentence = new WbsSentence();
        WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, sentence);
        this.getLogger().debug("sentence=" + sentence.sentence);
        TextSummarizeTask textSummarizeTask = new TextSummarizeTask();
        textSummarizeTask.sentence = sentence;
        BcResult result = new BcResult();
        WbsProgress progress = new WbsProgress();
        if (!result.hasError()) {
            ExecutorService executorService = Executors.newCachedThreadPool();
            textSummarizeTask.future = executorService.submit(textSummarizeTask);
            executorService.shutdown();
            XwebUtil.putToMap(tokenContext.map, textSummarizeTask);
            progress.statusId = WbxConstants.ProgressStatus.OK.id;
            progress.data = XwebUtil.createTokenString(tokenContext);
            progress.message = "\u6587\u7ae0\u3092\u89e3\u6790\u4e2d...";
            this.getLogger().debug("upload:token=" + progress.data);
        } else {
            progress.statusId = WbxConstants.ProgressStatus.NG.id;
            progress.message = BcMessageCreator.getInstance().createMessage(result.getErrorList());
        }
        ObjectMapper objectMapper = JacksonUtil.getObjectMapper();
        String jsonStr = objectMapper.writeValueAsString((Object)progress);
        WbfwUtil.outputJsonStr(wcbArg, jsonStr);
        XwebMailHelper.getInstance().addMailToWebMaster(wcbArg.getSiteContext(), this.getClass().getName(), "");
    }

    public void getProgress(HtsvArgument wcbArg) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.status);
        HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
        String token = XwebUtil.createTokenString(tokenContext);
        TextSummarizeTask task = (TextSummarizeTask)tokenContext.map.get(TextSummarizeTask.class.getName());
        WbsProgress progress = new WbsProgress();
        if (task.future.isDone()) {
            if (task.future.isCancelled() || task.getThrowable() != null) {
                progress.statusId = WbxConstants.ProgressStatus.NG.id;
            } else {
                progress.statusId = WbxConstants.ProgressStatus.Finished.id;
                progress.data = task.sentence.conveted;
            }
        } else {
            progress.statusId = WbxConstants.ProgressStatus.OK.id;
        }
        progress.message = task.message;
        ObjectMapper objectMapper = JacksonUtil.getObjectMapper();
        String jsonStr = objectMapper.writeValueAsString((Object)progress);
        WbfwUtil.outputJsonStr(wcbArg, jsonStr);
    }

    public void submitXXXX(HtsvArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            this.submit_L2(wcbArg, dtsSessionSite);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void submit_L2(HtsvArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.form);
        HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
        WbsSentence sentence = new WbsSentence();
        WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, sentence);
        XsysValidator validator = XsysValidator.getInstance();
        tokenContext.validationResult = validator.validate(sentence);
        XwebUtil.putToMap(tokenContext.map, sentence);
        if (!tokenContext.validationResult.hasError()) {
            NlpRestRequest restRequest = new NlpRestRequest();
            restRequest.mode = "aaa";
            restRequest.text = sentence.sentence;
            String url = "http://192.168.2.81:8901/post";
            NlpRestHelper restHelper = new NlpRestHelper();
            try {
                NlpRestResponse restResponse = restHelper.post(url, restRequest);
                this.getLogger().debug("restResponse.text=" + restResponse.text);
                sentence.conveted = restResponse.text;
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
                tokenContext.validationResult.result.addError(ex);
            }
        }
        if (tokenContext.validationResult.hasError()) {
            XwebUtil.inputErrorPreprocessing(tokenContext, requestParameter, tokenContext.validationResult);
            String param1 = WbfwUtil.createParameter((Enum)WbxConstants.SessionAttributeKey.token, XwebUtil.createTokenString(tokenContext));
            String href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.form)) + WbfwUtil.createUrlQuery(param1);
            wcbArg.getResponse().sendRedirect(href);
            return;
        }
        XwebUtil.removeTokenContext(wcbArg, tokenContext);
        this.form(wcbArg);
    }

    public static enum Method implements WbxPath
    {
        form("text-summarize"),
        submit("text-summarize-submit"),
        getProgress("text-summarize-progress");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return AsemTextSummarizeWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

