/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.time.DateTimeException;
import java.time.chrono.Era;
import java.time.chrono.MinguoChronology;
import java.time.chrono.MinguoDate;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Locale;

public enum MinguoEra implements Era
{
    BEFORE_ROC,
    ROC;


    public static MinguoEra of(int n) {
        switch (n) {
            case 0: {
                return BEFORE_ROC;
            }
            case 1: {
                return ROC;
            }
        }
        throw new DateTimeException("Invalid era: " + n);
    }

    @Override
    public int getValue() {
        return this.ordinal();
    }

    @Override
    public String getDisplayName(TextStyle textStyle, Locale locale) {
        return new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.ERA, textStyle).toFormatter(locale).withChronology(MinguoChronology.INSTANCE).format(this == ROC ? MinguoDate.of(1, 1, 1) : MinguoDate.of(0, 1, 1));
    }
}

