/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.common;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcPair;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.util.HtmlUtil;
import jp.co.extreme.module.wbfw.common.WbfSiteContext;
import jp.co.extreme.module.wbfw.container.WbfwWcbArgument;
import jp.co.extreme.module.wbs1.dao.Wbs1QuestionDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Answer;
import jp.co.extreme.module.wbs1.model.Wbs1Question;
import jp.co.extreme.module.xweb.common.HtmlDlCreator;
import jp.co.extreme.person.common.PsnPersonConstants;
import jp.co.extreme.person.util.PsnPersonUtil;

public final class XwebQuestionUtil {
    static HtmlDlCreator dlCreator = new HtmlDlCreator();

    private XwebQuestionUtil() {
    }

    public static long getQuestionSetId(WbfSiteContext siteContext, PsnPersonConstants.Sex sex) throws Exception {
        String questionIdStr = null;
        if (sex == PsnPersonConstants.Sex.male) {
            questionIdStr = siteContext.propertyMap.get(QuestionId.x_questionId_m.name());
        } else if (sex == PsnPersonConstants.Sex.female) {
            questionIdStr = siteContext.propertyMap.get(QuestionId.x_questionId_f.name());
        } else {
            throw new Exception("sex is null.");
        }
        if (BcStringUtil.isEmpty(questionIdStr)) {
            throw new Exception("\u30b5\u30a4\u30c8\u30d7\u30ed\u30d1\u30c6\u30a3\u306b\u8cea\u554f\u30bb\u30c3\u30c8ID\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        long questionSetId = BcNumberUtil.parseLong(questionIdStr);
        return questionSetId;
    }

    public static long getQuestionSetId(WbfSiteContext siteContext, String sexCode) throws Exception {
        PsnPersonConstants.Sex sex = PsnPersonUtil.toSexByCode(sexCode);
        return XwebQuestionUtil.getQuestionSetId(siteContext, sex);
    }

    public static List<Wbs1Question> getQuestionList(WbfwWcbArgument wcbArg, DtsSession dtsSessionSite, PsnPersonConstants.Sex sex) throws Exception {
        long questionSetId = XwebQuestionUtil.getQuestionSetId(wcbArg.getSiteContext(), sex);
        List<Wbs1Question> questionList = Wbs1QuestionDAO.getInstance().getList(dtsSessionSite, questionSetId);
        return questionList;
    }

    public static List<Wbs1Question> getQuestionList(WbfwWcbArgument wcbArg, DtsSession dtsSessionSite, String sexCode) throws Exception {
        PsnPersonConstants.Sex sex = PsnPersonUtil.toSexByCode(sexCode);
        return XwebQuestionUtil.getQuestionList(wcbArg, dtsSessionSite, sex);
    }

    public static short arrayIndexToQuestionNumber(int arrayIndex) {
        return (short)(arrayIndex + 1);
    }

    public static boolean isHit(List<String> ques, String[] items) throws Exception {
        boolean hit = false;
        int j = 0;
        while (j < ques.size()) {
            String value = ques.get(j);
            if (value != null) {
                BcLogUtil.debug("answer.items[j]=" + items[j]);
                ArrayList<String> strArray = null;
                if (value instanceof List) {
                    strArray = (ArrayList<String>)((Object)value);
                } else {
                    strArray = new ArrayList<String>();
                    strArray.add(value);
                }
                int k = 0;
                while (k < strArray.size()) {
                    String aa = (String)strArray.get(k);
                    BcLogUtil.debug("aa=" + aa);
                    if (aa.equals(items[j])) {
                        hit = true;
                        break;
                    }
                    ++k;
                }
                if (hit) break;
            }
            ++j;
        }
        return hit;
    }

    public static List<BcPair> toPairList(List<Wbs1Question> questionList, Wbs1Answer answer, boolean flag) throws Exception {
        ArrayList<BcPair> pairList = new ArrayList<BcPair>();
        int i = 0;
        while (i < questionList.size()) {
            Wbs1Question question = questionList.get(i);
            if (!flag || question.profile_flag > 0) {
                pairList.add(new BcPair<String, String>(question.name, HtmlUtil.encode(answer.items[i])));
            }
            ++i;
        }
        return pairList;
    }

    public static String getAnswerHtml(HtmlBuilder htmlBuilder, List<Wbs1Question> questionList, Wbs1Answer answer, boolean flag) throws Exception {
        List<BcPair> pairList = XwebQuestionUtil.toPairList(questionList, answer, flag);
        StringBuilder sb = new StringBuilder();
        sb.append(htmlBuilder.div_start("data"));
        XwebQuestionUtil.dlCreator.dlClass = "dl_1";
        XwebQuestionUtil.dlCreator.dtSameWidth = true;
        XwebQuestionUtil.dlCreator.dtAfter = ":";
        XwebQuestionUtil.dlCreator.dtHorizonalAlignment = 4;
        sb.append((CharSequence)dlCreator.create(pairList));
        sb.append(htmlBuilder.div_end());
        return sb.toString();
    }

    public static String get\u81ea\u5df1\u7d39\u4ecb(HtmlBuilder htmlBuilder, List<Wbs1Question> questionList, Wbs1Answer answer) throws Exception {
        StringBuilder sb = new StringBuilder();
        int index = -1;
        int i = 0;
        while (i < questionList.size()) {
            Wbs1Question question = questionList.get(i);
            if ("\u81ea\u5df1\u7d39\u4ecb".equals(question.name)) {
                index = question.number - 1;
            }
            ++i;
        }
        if (index >= 0) {
            BcStringUtil.append(sb, answer.items[index]);
        }
        return sb.toString();
    }

    public static enum QuestionId {
        x_questionId_m,
        x_questionId_f;

    }
}

