/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsys.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.MenuBar;
import javafx.scene.control.Tab;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcReflectUtil;
import jp.co.extreme.fx.control.FxTabPane;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.fx.XdtsMenuPane;
import jp.co.extreme.module.xfil.fx.XfilMenuPane;
import jp.co.extreme.module.xsys.common.XsysConstants;
import jp.co.extreme.module.xsys.fx.XysMenuIF;

public class XsysMenuPane
extends FxBorderPane {
    List<String> classNameList = new ArrayList<String>();
    List<XysMenuIF> instanceList = new ArrayList<XysMenuIF>();

    public XsysMenuPane() throws Exception {
        AfbApplication application = AfbApplication.getInstance();
        String type = application.properties.getProperty("type");
        if (XsysConstants.AppType.DatabaseClient.appType.equals(type)) {
            this.classNameList.add(XdtsMenuPane.class.getName());
        } else if (XsysConstants.AppType.MovieFiler.appType.equals(type)) {
            this.classNameList.add(XfilMenuPane.class.getName());
        }
        if (this.classNameList.size() == 1) {
            this.setComponant_1();
        } else {
            this.setComponant_TabPane();
        }
        this.start();
    }

    protected void setComponant_1() throws Exception {
        String className = this.classNameList.get(0);
        Class<?> clazz = Class.forName(className);
        XysMenuIF menuInterface = (XysMenuIF)BcReflectUtil.createInstance(clazz);
        this.instanceList.add(menuInterface);
        this.setCenter((Node)menuInterface);
        FxUtil.setPaddingDefault((Region)this);
    }

    protected void setComponant_TabPane() throws Exception {
        FxTabPane tabPane1 = new FxTabPane();
        tabPane1.setSide(Side.TOP);
        int i = 0;
        while (i < this.classNameList.size()) {
            String className = this.classNameList.get(i);
            XysMenuIF menuInterface = null;
            try {
                Class<?> clazz = Class.forName(className);
                menuInterface = (XysMenuIF)BcReflectUtil.createInstance(clazz);
                this.instanceList.add(menuInterface);
            }
            catch (ClassNotFoundException ex) {
                BcLogUtil.error(ex);
            }
            catch (Exception ex) {
                throw ex;
            }
            Tab tab = new Tab();
            tab.setText(menuInterface.getTitle());
            tab.setGraphic((Node)menuInterface.getImageView());
            tab.setContent((Node)menuInterface);
            tab.setClosable(false);
            tabPane1.getTabs().add((Object)tab);
            ++i;
        }
        if (tabPane1.getTabs().size() > 0) {
            Tab tab = (Tab)tabPane1.getTabs().get(0);
            tabPane1.getSelectionModel().select((Object)tab);
        }
        StackPane stackPane = new StackPane();
        stackPane.getChildren().addAll((Object[])new Node[]{tabPane1});
        this.setCenter((Node)stackPane);
        FxUtil.setPaddingDefault((Region)this);
    }

    public void setMenu(MenuBar menuBar) throws Exception {
        int i = 0;
        while (i < this.instanceList.size()) {
            XysMenuIF menuIF = this.instanceList.get(i);
            menuIF.setMenu(menuBar);
            ++i;
        }
    }

    public void start() throws Exception {
        int i = 0;
        while (i < this.instanceList.size()) {
            XysMenuIF menuIF = this.instanceList.get(i);
            menuIF.start();
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
    }
}

