/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.lib.editorjs.EditorJsUtil;
import jp.co.extreme.module.wbfw.common.WbfwUploadContext;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbfw.container.WbfwRequestParameter;
import jp.co.extreme.module.wbfw.container.WbfwWcbArgument;
import jp.co.extreme.module.wbs1.common.Wbs1Constants;
import jp.co.extreme.module.wbs1.server.ArticleManager;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractDashboardWCB;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xsod.common.EtcImageCash;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.WbxTokenContext;
import jp.co.extreme.module.xweb.common.XwebUtil;

public class Wbs1EditorJsHelperWCB
extends Wbs1AbstractDashboardWCB {
    public void imageUpload(WbfwWcbArgument wcbArg) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg);
        WbfwRequestParameter requestParameter = wcbArg.getRequestParameter();
        if (tokenContext == null) {
            wcbArg.getResponse().sendError(400);
            return;
        }
        if (BcCollectionUtil.isEmpty(requestParameter.uploadContextList)) {
            wcbArg.getResponse().sendError(400);
            return;
        }
        String fileNameOrig = null;
        File newFile = null;
        int i = 0;
        while (i < requestParameter.uploadContextList.size()) {
            WbfwUploadContext uploadContext = requestParameter.uploadContextList.get(i);
            this.getLogger().debug("uploadContext.fileName=" + uploadContext.fileName);
            this.getLogger().debug("uploadContext.tempFile=" + uploadContext.tempFile.getPath());
            if (!BcStringUtil.isEmpty(uploadContext.fileName)) {
                fileNameOrig = uploadContext.fileName;
                String newFileName = BcFileUtil.createFileName(BcFileUtil.getBaseName(uploadContext.tempFile), BcFileUtil.getExtention(uploadContext.fileName));
                newFile = new File(uploadContext.tempFile.getParentFile(), newFileName);
                BcFileUtil.rename(uploadContext.tempFile, newFile);
                break;
            }
            ++i;
        }
        String param1 = WbfwUtil.createParameter(WbxConstants.SessionAttributeKey.token.name(), (Object)XwebUtil.createTokenString(tokenContext));
        String param2 = WbfwUtil.createParameter("fileName", (Object)newFile.getName());
        String param3 = WbfwUtil.createParameter("fileNameOrig", fileNameOrig);
        String param4 = WbfwUtil.createParameter("temp", fileNameOrig);
        String href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.articleImage)) + WbfwUtil.createUrlQuery(param1, param2, param3, param4);
        Map map = EditorJsUtil.createResponse(href);
        WbfwUtil.outputJson(wcbArg, map);
    }

    public void articleImage(WbfwWcbArgument wcbArg) throws Exception {
        File dir;
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg);
        WbfwRequestParameter requestParameter = wcbArg.getRequestParameter();
        if (tokenContext == null) {
            wcbArg.getResponse().sendError(400);
            return;
        }
        String tmpStr = requestParameter.getAsString(Wbs1Constants.ArticleParam.articleId.name());
        long articleId = BcNumberUtil.parseLong(tmpStr, -1);
        this.getLogger().debug("articleId=" + articleId);
        String fileName = requestParameter.getAsString("fileName");
        this.getLogger().debug("fileName=" + fileName);
        File file = null;
        if (articleId > 0L) {
            dir = ArticleManager.getInstance().getDir(wcbArg.getSiteContext(), articleId, false);
            file = new File(dir, fileName);
        } else {
            dir = AfbApplication.getInstance().getTempDir();
            file = new File(dir, fileName);
        }
        XfilUriEntity uriEntity = XfilUtil.toUriEntity(file.toPath(), true);
        EtcImageCash imageCash = new EtcImageCash();
        BufferedImage bufferedImage = imageCash.getImage((Comparable)((Object)fileName), file);
        if ("webp".equalsIgnoreCase(uriEntity.extention)) {
            WbfwUtil.outputFile(wcbArg, file);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, uriEntity.extention, (OutputStream)wcbArg.getResponse().getOutputStream());
        }
    }

    public static enum Method implements WbxPath
    {
        imageUpload("editorImageUpload"),
        articleImage("articleImage");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

