/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbfw.session;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContext;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcRandamUtil;
import jp.co.extreme.module.wbfw.common.WbfSiteContext;
import jp.co.extreme.module.wbfw.common.WbfwResourceHolder;
import jp.co.extreme.module.wbfw.container.WbfwWcbArgument;
import jp.co.extreme.module.wbfw.session.WbfwHttpSession;
import jp.co.extreme.module.wbfw.session.WbxSessionManager;
import jp.co.extreme.scf.scheduler.ScfTimerTask;

public class WbfwSessionManagerMem
extends BcLoggableObject
implements WbxSessionManager {
    private Map<String, WbfwHttpSession> httpSessionMap = new HashMap<String, WbfwHttpSession>();
    private InnerLifeCheckTask lifeCheckTask;
    private Timer timer;
    Random random = new Random();
    int sessrionIdLent = 24;

    @Override
    public WbfwHttpSession createSession(ServletContext servletContext, int maxInactiveInterval) {
        String sessrionId;
        while (this.httpSessionMap.containsKey(sessrionId = BcRandamUtil.createCode(this.random, 5, this.sessrionIdLent))) {
        }
        WbfwHttpSession httpSession = new WbfwHttpSession();
        httpSession.setId(sessrionId);
        httpSession.setCreationTime(System.currentTimeMillis());
        httpSession.setLastAccessedTime(httpSession.getCreationTime());
        httpSession.setServletContext(servletContext);
        httpSession.setMaxInactiveInterval(maxInactiveInterval);
        this.httpSessionMap.put(httpSession.getId(), httpSession);
        this.getLogger().debug("WbfwSessionManagerMem#createSession:httpSession.getId()=" + httpSession.getId());
        return httpSession;
    }

    @Override
    public WbfwHttpSession getSession(String sessionId) {
        WbfwHttpSession httpSession = this.httpSessionMap.get(sessionId);
        if (httpSession != null) {
            httpSession.setLastAccessedTime(System.currentTimeMillis());
        }
        return httpSession;
    }

    @Override
    public void storeSession(WbfwWcbArgument wcbArg, WbfwHttpSession httpSession) throws Exception {
        BcLogUtil.debug("WbfwSessionManagerMem.storeHttpSession:sessrionId=" + httpSession.getId());
        this.httpSessionMap.put(httpSession.getId(), httpSession);
    }

    @Override
    public void removeSession(String sessionId) throws Exception {
        this.httpSessionMap.remove(sessionId);
    }

    @Override
    public void startSesionLifeCheck() throws Exception {
        WbfSiteContext siteContext = WbfwResourceHolder.getInstance().webContainer.getSiteContextDefault();
        this.lifeCheckTask = new InnerLifeCheckTask(this);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this.lifeCheckTask, siteContext.sessionLifeCheckInterval * 1000, (long)(siteContext.sessionLifeCheckInterval * 1000));
        BcLogUtil.info("HTTP session lifeCheckTask started.");
    }

    @Override
    public void desutuct() throws Exception {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.lifeCheckTask = null;
        this.timer = null;
    }

    public void checkSessionLife() throws Exception {
        WbfwHttpSession[] httpSessions = this.httpSessionMap.values().toArray(new WbfwHttpSession[0]);
        int i = 0;
        while (i < httpSessions.length) {
            long term;
            WbfwHttpSession httpSession = httpSessions[i];
            if (httpSession.endTime <= 0L && httpSession.getMaxInactiveInterval() > 0 && (term = System.currentTimeMillis() - httpSession.getLastAccessedTime()) > (long)(httpSession.getMaxInactiveInterval() * 1000)) {
                httpSession.endTime = System.currentTimeMillis();
                this.removeSession(httpSession.getId());
                BcLogUtil.debug("HTTP Session Timeout: id=" + httpSession.getId() + " \u7d4c\u904e\u6642\u9593\uff08\u30df\u30ea\u79d2\uff09 =" + term);
            }
            ++i;
        }
    }

    protected class InnerLifeCheckTask
    extends ScfTimerTask {
        WbfwSessionManagerMem httpSessionManager;

        public InnerLifeCheckTask(WbfwSessionManagerMem httpSessionManager) {
            this.httpSessionManager = httpSessionManager;
        }

        @Override
        protected void run2() throws Exception {
            this.httpSessionManager.checkSessionLife();
        }
    }
}

