/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbfw.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcCipherUtil;
import jp.co.extreme.module.wbfw.common.WbfwUrlParameterMap;

public final class XwebEncryptor {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private String key = "ABRACADABRA";

    public static XwebEncryptor getInstance() {
        return SingletonHolder.instance;
    }

    public String encrypt(String text) throws Exception {
        return BcCipherUtil.encryptText(this.key, text);
    }

    public String encryptMap(String key, Map<String, Object> map) throws Exception {
        String jsonText = this.objectMapper.writeValueAsString(map);
        return BcCipherUtil.encryptText(key, jsonText);
    }

    public String encryptMap(Map<String, Object> map) throws Exception {
        return this.encryptMap(this.key, map);
    }

    public String decrypt(String text, String defaultValue) throws Exception {
        try {
            return BcCipherUtil.decrypt(this.key, text);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            BcLogUtil.error("decrypt:text=" + text);
            return defaultValue;
        }
    }

    public String decrypt(String text) throws Exception {
        return BcCipherUtil.decrypt(this.key, text);
    }

    public WbfwUrlParameterMap decryptMap(String key, String encryptStr) throws Exception {
        String decryptStr = BcCipherUtil.decrypt(key, encryptStr);
        WbfwUrlParameterMap map = (WbfwUrlParameterMap)this.objectMapper.readValue(decryptStr, WbfwUrlParameterMap.class);
        return map;
    }

    public WbfwUrlParameterMap decryptMap(String encryptStr) throws Exception {
        return this.decryptMap(this.key, encryptStr);
    }

    private static final class SingletonHolder {
        private static final XwebEncryptor instance = new XwebEncryptor();

        private SingletonHolder() {
        }
    }
}

