/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.tbcp.common;

import java.util.List;
import java.util.Map;
import jp.co.extreme.base.log.BcLogHelper;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcDifference;
import jp.co.extreme.module.tbcp.common.TbcpCellNull;
import jp.co.extreme.module.tbcp.common.TbcpCondition;
import jp.co.extreme.module.tbcp.common.TbcpTableComparator;
import jp.co.extreme.module.xsys.common.XsysConstants;
import jp.co.extreme.nlp.NlpNoun;
import jp.co.extreme.poi.PoiWorkbookUtil;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TbcpTableToExcel
extends BcLoggableObject {
    public int rowHeight = 16;
    XSSFFont fontBase;
    XSSFFont fontRed;
    String title;

    public XSSFWorkbook createWorkbook(BcTableModel tableModel, Map<String, BcDifference> diffMap, int tbaleIndex, TbcpCondition condition) throws Exception {
        this.getLogger().info("Creating the workbook... ");
        XSSFWorkbook workbook = new XSSFWorkbook();
        this.fontBase = this.createFont(workbook);
        this.fontBase.setColor(IndexedColors.BLACK.getIndex());
        this.fontRed = this.createFont(workbook);
        this.fontRed.setColor(IndexedColors.RED.getIndex());
        XSSFCellStyle cellStyle1 = workbook.createCellStyle();
        this.setCellStyle((CellStyle)cellStyle1, (Font)this.fontBase);
        XSSFCellStyle cellStyle2 = workbook.createCellStyle();
        this.setCellStyle((CellStyle)cellStyle2, (Font)this.fontBase);
        cellStyle2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle2.setFillForegroundColor(IndexedColors.LEMON_CHIFFON.getIndex());
        XSSFSheet sheet = workbook.createSheet();
        int sheetIndex = workbook.getSheetIndex((Sheet)sheet);
        workbook.setSheetName(sheetIndex, "Sheet1");
        int i = 0;
        while (i < tableModel.getRowCount()) {
            if (i % 100 == 0) {
                this.getLogger().info("Creating the workbook... " + BcLogHelper.countBrackets(tableModel.getRowCount(), i, true));
            }
            XSSFRow row = sheet.createRow(i);
            row.setHeightInPoints((float)this.rowHeight);
            int j = 0;
            while (j < tableModel.getColumnCount()) {
                this.createCell(row, j, tableModel, diffMap, tbaleIndex, (CellStyle)cellStyle1, (CellStyle)cellStyle2, condition);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < tableModel.getColumnCount()) {
            sheet.autoSizeColumn(i);
            ++i;
        }
        this.setProperties(workbook);
        return workbook;
    }

    protected void createCell(XSSFRow row, int columnId, BcTableModel tableModel, Map<String, BcDifference> diffMap, int tbaleIndex, CellStyle cellStyle1, CellStyle cellStyle2, TbcpCondition condition) throws Exception {
        XSSFCell cell = row.createCell(columnId);
        Object value = tableModel.getValueAt(row.getRowNum(), columnId);
        String key = TbcpTableComparator.createKey(row.getRowNum(), columnId);
        BcDifference difference = diffMap.get(key);
        if (value instanceof CharSequence) {
            CharSequence newValue = null;
            CharSequence charSequence = (CharSequence)value;
            List nounList = null;
            if (difference != null) {
                nounList = (List)difference.arrayInfo;
            }
            if (BcCollectionUtil.isEmpty(nounList)) {
                newValue = charSequence;
            } else {
                XSSFRichTextString richTextString = this.createRichTextString(charSequence.toString(), nounList);
                newValue = richTextString;
            }
            PoiWorkbookUtil.setCellValue((Cell)cell, newValue);
        }
        if (difference == null) {
            cell.setCellStyle(cellStyle1);
        } else {
            cell.setCellStyle(cellStyle2);
            if (condition.comment) {
                this.setComment(cell, difference, tbaleIndex);
            }
        }
    }

    protected XSSFRichTextString createRichTextString(String str, List<NlpNoun> nounList) throws Exception {
        XSSFRichTextString richTextString = new XSSFRichTextString();
        richTextString.setString(str);
        NlpNoun preNoun = null;
        int i = 0;
        while (i < nounList.size()) {
            NlpNoun noun = nounList.get(i);
            if (preNoun != null) {
                richTextString.applyFont(preNoun.endIndex, noun.beginIndex, (Font)this.fontBase);
            }
            if (noun.endIndex >= 0) {
                richTextString.applyFont(noun.beginIndex, noun.endIndex, (Font)this.fontRed);
            } else {
                richTextString.applyFont(noun.beginIndex, str.length(), (Font)this.fontRed);
            }
            preNoun = noun;
            ++i;
        }
        if (preNoun.endIndex >= 0) {
            richTextString.applyFont(preNoun.endIndex, str.length(), (Font)this.fontBase);
        }
        return richTextString;
    }

    protected void setComment(XSSFCell cell, BcDifference difference, int tbaleIndex) throws Exception {
        Object value = null;
        value = tbaleIndex == 0 ? difference.value2 : difference.value1;
        XSSFRichTextString richTextString = null;
        if (value instanceof CharSequence) {
            List nounList = (List)difference.arrayInfo;
            if (BcCollectionUtil.isEmpty(nounList)) {
                richTextString = new XSSFRichTextString();
                richTextString.setString(value.toString());
            } else {
                richTextString = this.createRichTextString(value.toString(), nounList);
            }
        } else if (value instanceof TbcpCellNull) {
            richTextString = new XSSFRichTextString();
            richTextString.setString(value.toString());
        }
        if (richTextString == null) {
            return;
        }
        XSSFRow row = cell.getRow();
        XSSFWorkbook workbook = row.getSheet().getWorkbook();
        XSSFCreationHelper creationHelper = workbook.getCreationHelper();
        XSSFDrawing drawing = row.getSheet().createDrawingPatriarch();
        ClientAnchor anchor = creationHelper.createClientAnchor();
        anchor.setCol1(cell.getColumnIndex());
        anchor.setRow1(row.getRowNum());
        anchor.setCol2(cell.getColumnIndex() + 4);
        anchor.setRow2(row.getRowNum() + 1);
        Comment comment = drawing.createCellComment(anchor);
        comment.setString((RichTextString)richTextString);
    }

    protected void setCellStyle(CellStyle cellStyle, Font font) throws Exception {
        cellStyle.setFont(font);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.DASHED);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setWrapText(true);
    }

    protected XSSFFont createFont(XSSFWorkbook workbook) throws Exception {
        XSSFFont font = workbook.createFont();
        font.setFontName("\uff2d\uff33 \u30b4\u30b7\u30c3\u30af");
        font.setFontHeightInPoints((short)11);
        return font;
    }

    protected void setProperties(XSSFWorkbook workbook) throws Exception {
        XsysConstants.setWorkbookProperties((Workbook)workbook, this.title);
    }
}

