/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.mmdx.common;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdIndex;
import jp.co.extreme.base.mmd.MmdIndexElement;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.util.BcPair;
import jp.co.extreme.datasource.util.DtsWordManagerImpl;
import jp.co.extreme.module.mmdx.model.MmdxField;
import jp.co.extreme.module.mmdx.model.MmdxIndex;
import jp.co.extreme.module.mmdx.model.MmdxModel;
import jp.co.extreme.module.mmdx.model.YwebFieldContext;
import jp.co.extreme.module.mmdx.model.YwebFieldPack;
import jp.co.extreme.orm.entity.OrmPersistenceEntity;
import jp.co.extreme.sql.SqlUtil;
import nlc.module.apcm.fx.Y_ApcmFxUtil3;
import nlc.module.apcm.model.ApcmFieldAnnotation;

public final class MmdxUtil {
    static DtsWordManagerImpl wordManager = new DtsWordManagerImpl();

    private MmdxUtil() {
    }

    public static MmdModel toMmdModel(MmdxModel mmdxModel, MmdModel mmdModel) throws Exception {
        mmdModel.modelName = mmdxModel.logicalName;
        mmdModel.tableName = mmdxModel.logicalName;
        mmdModel.wordCode = mmdxModel.wordCode;
        mmdModel.note = mmdxModel.note;
        int i = 0;
        while (i < mmdxModel.fieldList.size()) {
            MmdxField mmdxField = mmdxModel.fieldList.get(i);
            MmdField mmdField = MmdxUtil.toMmdField(mmdxField);
            mmdModel.addField(mmdField);
            ++i;
        }
        return mmdModel;
    }

    public static MmdModel toMmdModel(MmdxModel mmdxModel) throws Exception {
        MmdModel mmdModel = new MmdModel();
        return MmdxUtil.toMmdModel(mmdxModel, mmdModel);
    }

    public static void toMmdField(MmdxField mmdxField, MmdField mmdField) throws Exception {
        mmdField.columnName = mmdxField.columnName;
        mmdField.sqlTypeId = mmdxField.sqlTypeId;
        mmdField.dataSize = mmdxField.dataSize;
        mmdField.nullable = mmdxField.nullable;
        mmdField.decimalDigit = mmdxField.decimalDigit;
        mmdField.fieldDisplay.roundingMode = mmdxField.roundingMode;
        mmdField.ordinalPosition = mmdxField.ordinalPosition;
        mmdField.columnCount = mmdxField.columnCount;
        mmdField.fieldDisplay.rowCount = mmdxField.rowCount;
        mmdField.fieldDisplay.horizonalAlignment = mmdxField.horizonalAlignment;
        mmdField.fieldDisplay.verticalAlignment = mmdxField.verticalAlignment;
        mmdField.fieldDisplay.formatStr = mmdxField.format;
        mmdField.fieldDisplay.displayClassName = mmdxField.displayClass;
        mmdField.valueConverterClassName = mmdxField.datasourceConverter;
        mmdField.fieldDisplay.renderingConverterClassName = mmdxField.renderingConverter;
        mmdField.fieldDisplay.wordCode = mmdxField.wordCode;
        mmdField.remarks = mmdxField.note;
        mmdField.dataClass = SqlUtil.toJavaType(mmdxField.sqlTypeId);
    }

    public static MmdField toMmdField(MmdxField mmdxField) throws Exception {
        MmdField mmdField = new MmdField();
        MmdxUtil.toMmdField(mmdxField, mmdField);
        return mmdField;
    }

    public static MmdxModel toXmmdModel(MmdModel mmdModel, MmdxModel mmdxModel) throws Exception {
        mmdxModel.schemaId = 1;
        mmdxModel.tableName = mmdModel.tableName;
        mmdxModel.logicalName = mmdModel.modelName;
        mmdxModel.wordCode = mmdModel.wordCode;
        mmdxModel.note = mmdModel.note;
        int i = 0;
        while (i < mmdModel.fieldList.size()) {
            MmdField mmdField = mmdModel.fieldList.get(i);
            MmdxField mmdxField = MmdxUtil.toXmmdField(mmdField);
            mmdxModel.addField(mmdxField);
            ++i;
        }
        for (MmdIndex mmdIndex : mmdModel.indexMap.values()) {
            MmdxIndex mmdxIndex = MmdxUtil.toXmmdIndex(mmdIndex, mmdxModel);
            mmdxModel.addIndex(mmdxIndex);
        }
        mmdxModel.primaryIndexName = mmdModel.primaryIndexName;
        return mmdxModel;
    }

    public static MmdxModel toXmmdModel(MmdModel mmdModel) throws Exception {
        MmdxModel mmdxModel = new MmdxModel();
        MmdxUtil.toXmmdModel(mmdModel, mmdxModel);
        return mmdxModel;
    }

    public static void toXmmdField(MmdField mmdField, MmdxField mmdxField) {
        mmdxField.tableName = mmdField.tableName;
        mmdxField.columnName = mmdField.columnName;
        mmdxField.sqlTypeId = mmdField.sqlTypeId;
        mmdxField.dataSize = mmdField.dataSize;
        mmdxField.nullable = mmdField.nullable;
        mmdxField.decimalDigit = mmdField.decimalDigit;
        mmdxField.roundingMode = mmdField.fieldDisplay.roundingMode;
        mmdxField.ordinalPosition = mmdField.ordinalPosition;
        mmdxField.columnCount = mmdField.columnCount;
        mmdxField.rowCount = mmdField.fieldDisplay.rowCount;
        mmdxField.horizonalAlignment = mmdField.fieldDisplay.horizonalAlignment;
        mmdxField.verticalAlignment = mmdField.fieldDisplay.verticalAlignment;
        mmdxField.format = mmdField.fieldDisplay.formatStr;
        mmdxField.displayClass = mmdField.fieldDisplay.displayClassName;
        mmdxField.datasourceConverter = mmdField.valueConverterClassName;
        mmdxField.renderingConverter = mmdField.fieldDisplay.renderingConverterClassName;
        mmdxField.wordCode = mmdField.fieldDisplay.wordCode;
        mmdxField.note = mmdField.remarks;
    }

    public static MmdxField toXmmdField(MmdField mmdField) {
        MmdxField mmdxField = new MmdxField();
        MmdxUtil.toXmmdField(mmdField, mmdxField);
        return mmdxField;
    }

    public static MmdxIndex toXmmdIndex(MmdIndex mmdIndex, MmdxModel mmdxModel) throws Exception {
        MmdxIndex mmdxIndex = new MmdxIndex();
        mmdxIndex.schemaId = mmdxModel.schemaId;
        mmdxIndex.indexName = mmdIndex.name;
        mmdxIndex.isUnique = mmdIndex.isUnique;
        for (MmdIndexElement indexElement : mmdIndex.indexElementList) {
            MmdIndexElement indexElement2 = (MmdIndexElement)indexElement.clone();
            mmdxIndex.indexElementList.add(indexElement2);
        }
        return mmdxIndex;
    }

    public static List<String> toFieldNameList(List<MmdxField> fieldList) {
        ArrayList<String> fieldNameList = new ArrayList<String>();
        int i = 0;
        while (i < fieldList.size()) {
            MmdxField mmdxField = fieldList.get(i);
            fieldNameList.add(mmdxField.columnName);
            ++i;
        }
        return fieldNameList;
    }

    public static String createSelectQuery(MmdxModel mmdxModel) throws Exception {
        String columns = MmdxUtil.createColumns(mmdxModel);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT " + columns + " FROM " + mmdxModel.logicalName);
        return sql.toString();
    }

    public static String createColumns(MmdxModel mmdxModel) throws Exception {
        List<String> columnNameList = MmdxUtil.toColumnNameList(mmdxModel);
        return BcStringUtil.marge(columnNameList, BcStringUtil.COMMA_STR);
    }

    public static List<String> toColumnNameList(MmdxModel mmdxModel) throws Exception {
        ArrayList<String> columnNameList = new ArrayList<String>();
        int i = 0;
        while (i < mmdxModel.getFieldCount()) {
            MmdxField mmdxField = mmdxModel.getField(i);
            columnNameList.add(mmdxField.columnName);
            ++i;
        }
        return columnNameList;
    }

    public static StringBuilder createInsertQuery(MmdxModel mmdxModel, String lineSep, boolean num) throws Exception {
        String columns = MmdxUtil.createColumns(mmdxModel);
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO " + mmdxModel.logicalName);
        sql.append(lineSep);
        sql.append(" (" + columns + ")");
        sql.append(lineSep);
        sql.append(" VALUES");
        sql.append(lineSep);
        sql.append(" (");
        int i = 0;
        while (i < mmdxModel.getFieldCount()) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("?");
            if (num) {
                sql.append(Integer.toString(i + 1));
            }
            ++i;
        }
        sql.append(")");
        return sql;
    }

    public static StringBuilder createInsertQuery(MmdxModel mmdxModel) throws Exception {
        return MmdxUtil.createInsertQuery(mmdxModel, "", false);
    }

    public static MmdxModel createXmmdModel(Class entityClass) throws Exception {
        MmdModel mmdModel = MmdUtil.createMmdModel(entityClass);
        MmdxModel mmdxModel = MmdxUtil.toXmmdModel(mmdModel);
        return mmdxModel;
    }

    public static List<Map.Entry<Field, MmdField>> createFieldEntryList(Class entityClass) throws Exception {
        OrmPersistenceEntity persistenceEntity = entityClass.getAnnotation(OrmPersistenceEntity.class);
        List<Field> fieldList = MmdUtil.createFieldListWithSuper(entityClass);
        ArrayList<Map.Entry<Field, MmdField>> mapEntryList = new ArrayList<Map.Entry<Field, MmdField>>();
        int i = 0;
        while (i < fieldList.size()) {
            Field field = fieldList.get(i);
            MmdField mmdField = Y_ApcmFxUtil3.createMmd(field, persistenceEntity, wordManager);
            mmdField.ordinalPosition = i + 1;
            BcPair<Field, MmdField> mapEntry = new BcPair<Field, MmdField>(field, mmdField);
            mapEntryList.add(mapEntry);
            ++i;
        }
        return mapEntryList;
    }

    public static List<YwebFieldContext> createFieldContexList(Class entityClass, Object entity, String entityName) throws Exception {
        OrmPersistenceEntity persistenceEntity = entityClass.getAnnotation(OrmPersistenceEntity.class);
        List<Field> fieldList = MmdUtil.createFieldListWithSuper(entityClass);
        ArrayList<YwebFieldContext> fieldContextList = new ArrayList<YwebFieldContext>();
        int i = 0;
        while (i < fieldList.size()) {
            YwebFieldContext fieldContext = new YwebFieldContext();
            fieldContext.field = fieldList.get(i);
            fieldContext.mmdField = Y_ApcmFxUtil3.createMmd(fieldContext.field, persistenceEntity, wordManager);
            fieldContext.mmdField.ordinalPosition = i + 1;
            fieldContext.entity = entity;
            fieldContext.entityName = entityName;
            fieldContextList.add(fieldContext);
            ++i;
        }
        return fieldContextList;
    }

    public static YwebFieldPack creatFieldPack(Class entityClass, Object entity, String entityName) throws Exception {
        YwebFieldPack fieldPack = new YwebFieldPack();
        fieldPack.fieldContextMap = new HashMap<String, YwebFieldContext>();
        List<YwebFieldContext> fieldContextList = MmdxUtil.createFieldContexList(entityClass, entity, entityName);
        fieldPack.groupList = new ArrayList<List<YwebFieldContext>>();
        ArrayList<YwebFieldContext> fieldContextList2 = null;
        int i = 0;
        while (i < fieldContextList.size()) {
            YwebFieldContext fieldContext = fieldContextList.get(i);
            String mapKey = MmdxUtil.toMapKey(fieldContext);
            fieldPack.fieldContextMap.put(mapKey, fieldContext);
            int arrangement = 0;
            ApcmFieldAnnotation fieldAnnotation = fieldContext.field.getAnnotation(ApcmFieldAnnotation.class);
            if (fieldAnnotation != null) {
                arrangement = BcNumberUtil.parseInt(fieldAnnotation.arrangement(), 0);
            }
            if (arrangement != 1 || fieldContextList2 == null) {
                if (fieldContextList2 != null) {
                    fieldPack.groupList.add((List<YwebFieldContext>)fieldContextList2);
                }
                fieldContextList2 = new ArrayList<YwebFieldContext>();
            }
            fieldContextList2.add(fieldContext);
            ++i;
        }
        fieldPack.groupList.add(fieldContextList2);
        return fieldPack;
    }

    public static YwebFieldPack creatFieldPack(Object entity) throws Exception {
        return MmdxUtil.creatFieldPack(entity.getClass(), entity, entity.getClass().getSimpleName());
    }

    public static String toMapKey(String entityName, String fieldName) throws Exception {
        return String.valueOf(entityName) + "." + fieldName;
    }

    public static String toMapKey(YwebFieldContext fieldContext) throws Exception {
        return MmdxUtil.toMapKey(fieldContext.entityName, fieldContext.field.getName());
    }
}

