/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import jp.co.extreme.base.core.BcStringUtil;

public class BcMaskFomat
extends Format
implements Serializable {
    private static final long serialVersionUID = -4344833968718837508L;
    protected String pattern;
    protected int digit;

    public BcMaskFomat() {
    }

    public BcMaskFomat(String pattern) {
        this.setPattern(pattern);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.digit = BcStringUtil.getCharCount(pattern, '0', '#');
    }

    @Override
    public StringBuffer format(Object value, StringBuffer toAppendTo, FieldPosition pos) {
        String src = BcStringUtil.fillPrefix(value.toString(), this.digit, '0');
        int srcPos = 0;
        int i = 0;
        while (i < this.pattern.length()) {
            char srcChar;
            char patternChar = this.pattern.charAt(i);
            if (srcPos >= src.length()) break;
            if (patternChar == '0') {
                srcChar = src.charAt(srcPos);
                toAppendTo.append(srcChar);
                ++srcPos;
            } else if (patternChar == '#') {
                srcChar = src.charAt(srcPos);
                if (srcChar == '0') {
                    toAppendTo.append(' ');
                } else {
                    toAppendTo.append(srcChar);
                }
                ++srcPos;
            } else {
                toAppendTo.append(patternChar);
            }
            ++i;
        }
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return source;
    }
}

