/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLHandshakeException;
import sun.security.ssl.Alert;
import sun.security.ssl.ContentType;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.OutputRecord;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLCipher;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLRecord;
import sun.security.ssl.TransportContext;

final class SSLSocketOutputRecord
extends OutputRecord
implements SSLRecord {
    private OutputStream deliverStream = null;

    SSLSocketOutputRecord(HandshakeHash handshakeHash) {
        this(handshakeHash, (TransportContext)null);
    }

    SSLSocketOutputRecord(HandshakeHash handshakeHash, TransportContext transportContext) {
        super(handshakeHash, SSLCipher.SSLWriteCipher.nullTlsWriteCipher());
        this.tc = transportContext;
        this.packetSize = 16709;
        this.protocolVersion = ProtocolVersion.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encodeAlert(byte by, byte by2) throws IOException {
        this.recordLock.lock();
        try {
            int n;
            if (this.isClosed()) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.warning("outbound has closed, ignore outbound alert message: " + Alert.nameOf(by2), new Object[0]);
                }
                return;
            }
            this.count = n = 5 + this.writeCipher.getExplicitNonceSize();
            this.write(by);
            this.write(by2);
            if (SSLLogger.isOn && SSLLogger.isOn("record")) {
                SSLLogger.fine("WRITE: " + this.protocolVersion.name + " " + ContentType.ALERT.name + "(" + Alert.nameOf(by2) + "), length = " + (this.count - 5), new Object[0]);
            }
            this.encrypt(this.writeCipher, ContentType.ALERT.id, 5);
            this.deliverStream.write(this.buf, 0, this.count);
            this.deliverStream.flush();
            if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                SSLLogger.fine("Raw write", new ByteArrayInputStream(this.buf, 0, this.count));
            }
            this.count = 0;
        }
        finally {
            this.recordLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encodeHandshake(byte[] byArray, int n, int n2) throws IOException {
        this.recordLock.lock();
        try {
            byte by;
            if (this.isClosed()) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.warning("outbound has closed, ignore outbound handshake message", ByteBuffer.wrap(byArray, n, n2));
                }
                return;
            }
            if (this.firstMessage) {
                this.firstMessage = false;
                if (this.helloVersion == ProtocolVersion.SSL20Hello && byArray[n] == SSLHandshake.CLIENT_HELLO.id && byArray[n + 4 + 2 + 32] == 0) {
                    ByteBuffer byteBuffer = SSLSocketOutputRecord.encodeV2ClientHello(byArray, n + 4, n2 - 4);
                    byte[] byArray2 = byteBuffer.array();
                    int n3 = byteBuffer.limit();
                    this.handshakeHash.deliver(byArray2, 2, n3 - 2);
                    if (SSLLogger.isOn && SSLLogger.isOn("record")) {
                        SSLLogger.fine("WRITE: SSLv2 ClientHello message, length = " + n3, new Object[0]);
                    }
                    this.deliverStream.write(byArray2, 0, n3);
                    this.deliverStream.flush();
                    if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                        SSLLogger.fine("Raw write", new ByteArrayInputStream(byArray2, 0, n3));
                    }
                    return;
                }
            }
            if (this.handshakeHash.isHashable(by = byArray[0])) {
                this.handshakeHash.deliver(byArray, n, n2);
            }
            int n4 = this.getFragLimit();
            int n5 = 5 + this.writeCipher.getExplicitNonceSize();
            if (this.count == 0) {
                this.count = n5;
            }
            if (this.count - n5 < n4 - n2) {
                this.write(byArray, n, n2);
                return;
            }
            int n6 = n + n2;
            while (n < n6) {
                int n7 = n6 - n + (this.count - n5);
                int n8 = Math.min(n4, n7);
                this.write(byArray, n, n8);
                if (n7 < n4) {
                    return;
                }
                if (SSLLogger.isOn && SSLLogger.isOn("record")) {
                    SSLLogger.fine("WRITE: " + this.protocolVersion.name + " " + ContentType.HANDSHAKE.name + ", length = " + (this.count - 5), new Object[0]);
                }
                this.encrypt(this.writeCipher, ContentType.HANDSHAKE.id, 5);
                this.deliverStream.write(this.buf, 0, this.count);
                this.deliverStream.flush();
                if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                    SSLLogger.fine("Raw write", new ByteArrayInputStream(this.buf, 0, this.count));
                }
                n += n8;
                this.count = n5;
            }
        }
        finally {
            this.recordLock.unlock();
        }
    }

    @Override
    void encodeChangeCipherSpec() throws IOException {
        this.recordLock.lock();
        try {
            int n;
            if (this.isClosed()) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.warning("outbound has closed, ignore outbound change_cipher_spec message", new Object[0]);
                }
                return;
            }
            this.count = n = 5 + this.writeCipher.getExplicitNonceSize();
            this.write(1);
            this.encrypt(this.writeCipher, ContentType.CHANGE_CIPHER_SPEC.id, 5);
            this.deliverStream.write(this.buf, 0, this.count);
            if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                SSLLogger.fine("Raw write", new ByteArrayInputStream(this.buf, 0, this.count));
            }
            this.count = 0;
        }
        finally {
            this.recordLock.unlock();
        }
    }

    @Override
    void disposeWriteCipher() {
        this.writeCipher.dispose();
    }

    @Override
    public void flush() throws IOException {
        this.recordLock.lock();
        try {
            int n = 5 + this.writeCipher.getExplicitNonceSize();
            if (this.count <= n) {
                return;
            }
            if (SSLLogger.isOn && SSLLogger.isOn("record")) {
                SSLLogger.fine("WRITE: " + this.protocolVersion.name + " " + ContentType.HANDSHAKE.name + ", length = " + (this.count - 5), new Object[0]);
            }
            this.encrypt(this.writeCipher, ContentType.HANDSHAKE.id, 5);
            this.deliverStream.write(this.buf, 0, this.count);
            this.deliverStream.flush();
            if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                SSLLogger.fine("Raw write", new ByteArrayInputStream(this.buf, 0, this.count));
            }
            this.count = 0;
        }
        finally {
            this.recordLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void deliver(byte[] byArray, int n, int n2) throws IOException {
        this.recordLock.lock();
        try {
            if (this.isClosed()) {
                throw new SocketException("Connection or outbound has been closed");
            }
            if (this.writeCipher.authenticator.seqNumOverflow()) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.fine("sequence number extremely close to overflow (2^64-1 packets). Closing connection.", new Object[0]);
                }
                throw new SSLHandshakeException("sequence number overflow");
            }
            boolean bl = true;
            int n3 = n + n2;
            while (n < n3) {
                int n4;
                int n5;
                if (this.packetSize > 0) {
                    n5 = Math.min(16709, this.packetSize);
                    n5 = this.writeCipher.calculateFragmentSize(n5, 5);
                    n5 = Math.min(n5, 16384);
                } else {
                    n5 = 16384;
                }
                n5 = this.calculateFragmentSize(n5);
                if (bl && this.needToSplitPayload()) {
                    n5 = 1;
                    bl = false;
                } else {
                    n5 = Math.min(n5, n3 - n);
                }
                this.count = n4 = 5 + this.writeCipher.getExplicitNonceSize();
                this.write(byArray, n, n5);
                if (SSLLogger.isOn && SSLLogger.isOn("record")) {
                    SSLLogger.fine("WRITE: " + this.protocolVersion.name + " " + ContentType.APPLICATION_DATA.name + ", length = " + (this.count - n4), new Object[0]);
                }
                this.encrypt(this.writeCipher, ContentType.APPLICATION_DATA.id, 5);
                this.deliverStream.write(this.buf, 0, this.count);
                this.deliverStream.flush();
                if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                    SSLLogger.fine("Raw write", new ByteArrayInputStream(this.buf, 0, this.count));
                }
                this.count = 0;
                if (this.isFirstAppOutputRecord) {
                    this.isFirstAppOutputRecord = false;
                }
                n += n5;
            }
        }
        finally {
            this.recordLock.unlock();
        }
    }

    @Override
    void setDeliverStream(OutputStream outputStream) {
        this.recordLock.lock();
        try {
            this.deliverStream = outputStream;
        }
        finally {
            this.recordLock.unlock();
        }
    }

    private boolean needToSplitPayload() {
        return !this.protocolVersion.useTLS11PlusSpec() && this.writeCipher.isCBCMode() && !this.isFirstAppOutputRecord && Record.enableCBCProtection;
    }

    private int getFragLimit() {
        int n;
        if (this.packetSize > 0) {
            n = Math.min(16709, this.packetSize);
            n = this.writeCipher.calculateFragmentSize(n, 5);
            n = Math.min(n, 16384);
        } else {
            n = 16384;
        }
        n = this.calculateFragmentSize(n);
        return n;
    }
}

