/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.rcache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.ReplayCache;
import sun.security.krb5.internal.rcache.AuthList;
import sun.security.krb5.internal.rcache.AuthTimeWithHash;

public class MemoryCache
extends ReplayCache {
    private static final int lifespan = KerberosTime.getDefaultSkew();
    private static final boolean DEBUG = Krb5.DEBUG;
    private final Map<String, AuthList> content = new ConcurrentHashMap<String, AuthList>();

    @Override
    public synchronized void checkAndStore(KerberosTime kerberosTime, AuthTimeWithHash authTimeWithHash) throws KrbApErrException {
        String string2 = authTimeWithHash.client + "|" + authTimeWithHash.server;
        this.content.computeIfAbsent(string2, string -> new AuthList(lifespan)).put(authTimeWithHash, kerberosTime);
        if (DEBUG) {
            System.out.println("MemoryCache: add " + authTimeWithHash + " to " + string2);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (AuthList authList : this.content.values()) {
            stringBuilder.append(authList.toString());
        }
        return stringBuilder.toString();
    }
}

