/*
 * Decompiled with CFR 0.152.
 */
package sun.launcher;

import java.io.IOException;
import java.io.PrintStream;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import sun.misc.SharedSecrets;

public final class SecuritySettings {
    private static final String INDENT = "    ";
    private static final String TWOINDENT = "        ";
    private static final String THREEINDENT = "            ";
    private static final String PROV_INFO_STRING = "Provider information: ";
    private static PrintStream ostream = null;

    static void printSecuritySettings(String string, PrintStream printStream) {
        ostream = printStream;
        switch (string) {
            case "properties": {
                SecuritySettings.printSecurityProperties();
                break;
            }
            case "providers": {
                SecuritySettings.printSecurityProviderConfig(true);
                break;
            }
            case "tls": {
                SecuritySettings.printSecurityTLSConfig(true);
                break;
            }
            case "all": {
                SecuritySettings.printAllSecurityConfig();
                break;
            }
            default: {
                ostream.println("\nUnrecognized security subcommand. Valid values are \"all\", \"properties\", \"providers\", \"tls\". See \"java -X\"\n");
            }
        }
    }

    static void printSecuritySummarySettings(PrintStream printStream) {
        ostream = printStream;
        ostream.println("Security settings summary: \n    See \"java -X\" for verbose security settings options");
        SecuritySettings.printSecurityProviderConfig(false);
        SecuritySettings.printSecurityTLSConfig(false);
    }

    static void printAllSecurityConfig() {
        ostream.println("Security settings:");
        SecuritySettings.printSecurityProperties();
        SecuritySettings.printSecurityProviderConfig(true);
        SecuritySettings.printSecurityTLSConfig(true);
    }

    private static void printSecurityProperties() {
        ostream.println("    Security properties:");
        Properties properties = SharedSecrets.getJavaSecurityPropertiesAccess().getInitialProperties();
        for (String string : properties.stringPropertyNames().stream().sorted().collect(Collectors.toList())) {
            String string2 = properties.getProperty(string);
            if (string2.length() > 60) {
                SecuritySettings.splitLongPropertyLines(string, string2);
                continue;
            }
            ostream.println(TWOINDENT + string + "=" + string2);
        }
        ostream.println();
    }

    private static void splitLongPropertyLines(String string, String string2) {
        if (string2.contains(",") || string2.contains(";")) {
            String string4 = string2.contains(",") ? "," : ";";
            ostream.println(TWOINDENT + string + "=");
            String[] stringArray = string2.split(string4);
            String string5 = stringArray[stringArray.length - 1].trim();
            Arrays.asList(stringArray).forEach(string3 -> ostream.println(THREEINDENT + string3.trim() + (string3.trim().equals(string5) ? "" : string4)));
        } else {
            ostream.println(TWOINDENT + string + "=" + string2);
        }
    }

    private static void printSecurityTLSConfig(boolean bl) {
        SSLSocket sSLSocket;
        SSLContext sSLContext;
        try {
            sSLContext = SSLContext.getDefault();
            sSLSocket = (SSLSocket)sSLContext.getSocketFactory().createSocket();
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            ostream.println("    Failed to create SSL socket");
            ostream.println(INDENT + exception + "\n");
            return;
        }
        ostream.println("    Security TLS configuration (" + sSLContext.getProvider().getName() + " provider):");
        ostream.println("        Enabled Protocols:");
        for (String string : sSLSocket.getEnabledProtocols()) {
            ostream.println(THREEINDENT + string);
        }
        if (bl) {
            ostream.println("\n        Enabled Cipher Suites:");
            for (String string : sSLSocket.getEnabledCipherSuites()) {
                ostream.println(THREEINDENT + string);
            }
        }
        ostream.println();
    }

    private static void printSecurityProviderConfig(boolean bl) {
        ostream.println("    Security provider static configuration: (in order of preference)");
        for (Provider provider : Security.getProviders()) {
            if (bl) {
                ostream.println("        ----------------------------------------");
            }
            ostream.println("        Provider name: " + provider.getName());
            if (!bl) continue;
            ostream.println(SecuritySettings.wrappedString(PROV_INFO_STRING + provider.getInfo(), 80, TWOINDENT, THREEINDENT));
            ostream.println("        Provider services: (type : algorithm)");
            Set<Provider.Service> set = provider.getServices();
            Set set2 = Collections.list(provider.keys()).stream().map(String.class::cast).filter(string -> string.startsWith("Alg.Alias.")).collect(Collectors.toSet());
            if (!set.isEmpty()) {
                set.stream().sorted(Comparator.comparing(Provider.Service::getType).thenComparing(Provider.Service::getAlgorithm)).forEach(service -> {
                    ostream.println(THREEINDENT + service.getType() + "." + service.getAlgorithm());
                    List list = set2.stream().filter(string -> string.startsWith("Alg.Alias." + service.getType())).filter(string -> provider.getProperty((String)string).equals(service.getAlgorithm())).map(string -> string.substring(("Alg.Alias." + service.getType() + ".").length())).collect(Collectors.toList());
                    if (!list.isEmpty()) {
                        ostream.println(SecuritySettings.wrappedString(list.stream().collect(Collectors.joining(", ", "     aliases: [", "]")), 80, "         ", "                "));
                    }
                });
                continue;
            }
            ostream.println("            <none>");
        }
        if (bl) {
            ostream.println();
        }
    }

    private static String wrappedString(String string, int n, String string2, String string3) {
        if (string == null || string.isEmpty() || n <= 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (String string4 : string.split(" ")) {
            if (n2 == 0) {
                stringBuilder.append(string2 + string4);
                n2 = string4.length() + string2.length();
                continue;
            }
            if (n2 + string4.length() > n) {
                stringBuilder.append("\n" + string3 + string4);
                n2 = string4.length() + string3.length();
                continue;
            }
            stringBuilder.append(" " + string4);
            n2 += string4.length() + 1;
        }
        return stringBuilder.toString();
    }
}

