/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.time.temporal.Temporal;
import java.util.Map;
import org.apache.logging.log4j.util.Chars;
import org.apache.logging.log4j.util.InternalApi;
import org.apache.logging.log4j.util.StringBuilderFormattable;

@InternalApi
public final class StringBuilders {
    private static final Class<?> timeClass;
    private static final Class<?> dateClass;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.sql.Time");
        }
        catch (ClassNotFoundException ex) {
            clazz = null;
        }
        timeClass = clazz;
        try {
            clazz = Class.forName("java.sql.Date");
        }
        catch (ClassNotFoundException ex) {
            clazz = null;
        }
        dateClass = clazz;
    }

    private StringBuilders() {
    }

    public static StringBuilder appendDqValue(StringBuilder sb, Object value) {
        return sb.append('\"').append(value).append('\"');
    }

    public static StringBuilder appendKeyDqValue(StringBuilder sb, Map.Entry<String, String> entry) {
        return StringBuilders.appendKeyDqValue(sb, entry.getKey(), entry.getValue());
    }

    public static StringBuilder appendKeyDqValue(StringBuilder sb, String key, Object value) {
        return sb.append(key).append('=').append('\"').append(value).append('\"');
    }

    public static void appendValue(StringBuilder stringBuilder, Object obj) {
        if (!StringBuilders.appendSpecificTypes(stringBuilder, obj)) {
            stringBuilder.append(obj);
        }
    }

    public static boolean appendSpecificTypes(StringBuilder stringBuilder, Object obj) {
        if (obj == null || obj instanceof String) {
            stringBuilder.append((String)obj);
        } else if (obj instanceof StringBuilderFormattable) {
            ((StringBuilderFormattable)obj).formatTo(stringBuilder);
        } else if (obj instanceof CharSequence) {
            stringBuilder.append((CharSequence)obj);
        } else if (obj instanceof Integer) {
            stringBuilder.append((Integer)obj);
        } else if (obj instanceof Long) {
            stringBuilder.append((Long)obj);
        } else if (obj instanceof Double) {
            stringBuilder.append((Double)obj);
        } else if (obj instanceof Boolean) {
            stringBuilder.append((Boolean)obj);
        } else if (obj instanceof Character) {
            stringBuilder.append(((Character)obj).charValue());
        } else if (obj instanceof Short) {
            stringBuilder.append(((Short)obj).shortValue());
        } else if (obj instanceof Float) {
            stringBuilder.append(((Float)obj).floatValue());
        } else if (obj instanceof Byte) {
            stringBuilder.append(((Byte)obj).byteValue());
        } else if (StringBuilders.isTime(obj) || StringBuilders.isDate(obj) || obj instanceof Temporal) {
            stringBuilder.append(obj);
        } else {
            return false;
        }
        return true;
    }

    private static boolean isTime(Object obj) {
        return timeClass != null && timeClass.isAssignableFrom(obj.getClass());
    }

    private static boolean isDate(Object obj) {
        return dateClass != null && dateClass.isAssignableFrom(obj.getClass());
    }

    public static boolean equals(CharSequence left, int leftOffset, int leftLength, CharSequence right, int rightOffset, int rightLength) {
        if (leftLength == rightLength) {
            int i = 0;
            while (i < rightLength) {
                if (left.charAt(i + leftOffset) != right.charAt(i + rightOffset)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean equalsIgnoreCase(CharSequence left, int leftOffset, int leftLength, CharSequence right, int rightOffset, int rightLength) {
        if (leftLength == rightLength) {
            int i = 0;
            while (i < rightLength) {
                if (Character.toLowerCase(left.charAt(i + leftOffset)) != Character.toLowerCase(right.charAt(i + rightOffset))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static void trimToMaxSize(StringBuilder stringBuilder, int maxSize) {
        if (stringBuilder != null && stringBuilder.capacity() > maxSize) {
            stringBuilder.setLength(maxSize);
            stringBuilder.trimToSize();
        }
    }

    public static void escapeJson(StringBuilder toAppendTo, int start) {
        int escapeCount = 0;
        int i = start;
        while (i < toAppendTo.length()) {
            char c = toAppendTo.charAt(i);
            switch (c) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\"': 
                case '\\': {
                    ++escapeCount;
                    break;
                }
                default: {
                    if (!Character.isISOControl(c)) break;
                    escapeCount += 5;
                }
            }
            ++i;
        }
        int lastChar = toAppendTo.length() - 1;
        toAppendTo.setLength(toAppendTo.length() + escapeCount);
        int lastPos = toAppendTo.length() - 1;
        int i2 = lastChar;
        while (lastPos > i2) {
            char c = toAppendTo.charAt(i2);
            switch (c) {
                case '\b': {
                    lastPos = StringBuilders.escapeAndDecrement(toAppendTo, lastPos, 'b');
                    break;
                }
                case '\t': {
                    lastPos = StringBuilders.escapeAndDecrement(toAppendTo, lastPos, 't');
                    break;
                }
                case '\f': {
                    lastPos = StringBuilders.escapeAndDecrement(toAppendTo, lastPos, 'f');
                    break;
                }
                case '\n': {
                    lastPos = StringBuilders.escapeAndDecrement(toAppendTo, lastPos, 'n');
                    break;
                }
                case '\r': {
                    lastPos = StringBuilders.escapeAndDecrement(toAppendTo, lastPos, 'r');
                    break;
                }
                case '\"': 
                case '\\': {
                    lastPos = StringBuilders.escapeAndDecrement(toAppendTo, lastPos, c);
                    break;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        toAppendTo.setCharAt(lastPos--, Chars.getUpperCaseHex(c & 0xF));
                        toAppendTo.setCharAt(lastPos--, Chars.getUpperCaseHex((c & 0xF0) >> 4));
                        toAppendTo.setCharAt(lastPos--, '0');
                        toAppendTo.setCharAt(lastPos--, '0');
                        toAppendTo.setCharAt(lastPos--, 'u');
                        toAppendTo.setCharAt(lastPos--, '\\');
                        break;
                    }
                    toAppendTo.setCharAt(lastPos, c);
                    --lastPos;
                }
            }
            --i2;
        }
    }

    private static int escapeAndDecrement(StringBuilder toAppendTo, int lastPos, char c) {
        toAppendTo.setCharAt(lastPos--, c);
        toAppendTo.setCharAt(lastPos--, '\\');
        return lastPos;
    }

    public static void escapeXml(StringBuilder toAppendTo, int start) {
        int escapeCount = 0;
        int i = start;
        while (i < toAppendTo.length()) {
            char c = toAppendTo.charAt(i);
            switch (c) {
                case '&': {
                    escapeCount += 4;
                    break;
                }
                case '<': 
                case '>': {
                    escapeCount += 3;
                    break;
                }
                case '\"': 
                case '\'': {
                    escapeCount += 5;
                }
            }
            ++i;
        }
        int lastChar = toAppendTo.length() - 1;
        toAppendTo.setLength(toAppendTo.length() + escapeCount);
        int lastPos = toAppendTo.length() - 1;
        int i2 = lastChar;
        while (lastPos > i2) {
            char c = toAppendTo.charAt(i2);
            switch (c) {
                case '&': {
                    toAppendTo.setCharAt(lastPos--, ';');
                    toAppendTo.setCharAt(lastPos--, 'p');
                    toAppendTo.setCharAt(lastPos--, 'm');
                    toAppendTo.setCharAt(lastPos--, 'a');
                    toAppendTo.setCharAt(lastPos--, '&');
                    break;
                }
                case '<': {
                    toAppendTo.setCharAt(lastPos--, ';');
                    toAppendTo.setCharAt(lastPos--, 't');
                    toAppendTo.setCharAt(lastPos--, 'l');
                    toAppendTo.setCharAt(lastPos--, '&');
                    break;
                }
                case '>': {
                    toAppendTo.setCharAt(lastPos--, ';');
                    toAppendTo.setCharAt(lastPos--, 't');
                    toAppendTo.setCharAt(lastPos--, 'g');
                    toAppendTo.setCharAt(lastPos--, '&');
                    break;
                }
                case '\"': {
                    toAppendTo.setCharAt(lastPos--, ';');
                    toAppendTo.setCharAt(lastPos--, 't');
                    toAppendTo.setCharAt(lastPos--, 'o');
                    toAppendTo.setCharAt(lastPos--, 'u');
                    toAppendTo.setCharAt(lastPos--, 'q');
                    toAppendTo.setCharAt(lastPos--, '&');
                    break;
                }
                case '\'': {
                    toAppendTo.setCharAt(lastPos--, ';');
                    toAppendTo.setCharAt(lastPos--, 's');
                    toAppendTo.setCharAt(lastPos--, 'o');
                    toAppendTo.setCharAt(lastPos--, 'p');
                    toAppendTo.setCharAt(lastPos--, 'a');
                    toAppendTo.setCharAt(lastPos--, '&');
                    break;
                }
                default: {
                    toAppendTo.setCharAt(lastPos--, c);
                }
            }
            --i2;
        }
    }
}

