/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.bsd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.apache.commons.net.SocketClient;
import org.apache.commons.net.io.SocketInputStream;

public class RExecClient
extends SocketClient {
    protected static final char NULL_CHAR = '\u0000';
    public static final int DEFAULT_PORT = 512;
    private boolean remoteVerificationEnabled;
    protected InputStream _errorStream_ = null;

    public RExecClient() {
        this.setDefaultPort(512);
    }

    InputStream createErrorStream() throws IOException {
        Socket socket;
        Throwable throwable = null;
        Object var3_3 = null;
        try (ServerSocket server = this._serverSocketFactory_.createServerSocket(0, 1, this.getLocalAddress());){
            this._output_.write(Integer.toString(server.getLocalPort()).getBytes(StandardCharsets.UTF_8));
            this._output_.write(0);
            this._output_.flush();
            socket = server.accept();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (this.remoteVerificationEnabled && !this.verifyRemote(socket)) {
            socket.close();
            throw new IOException("Security violation: unexpected connection attempt by " + socket.getInetAddress().getHostAddress());
        }
        return new SocketInputStream(socket, socket.getInputStream());
    }

    @Override
    public void disconnect() throws IOException {
        if (this._errorStream_ != null) {
            this._errorStream_.close();
        }
        this._errorStream_ = null;
        super.disconnect();
    }

    public InputStream getErrorStream() {
        return this._errorStream_;
    }

    public InputStream getInputStream() {
        return this._input_;
    }

    public OutputStream getOutputStream() {
        return this._output_;
    }

    public final boolean isRemoteVerificationEnabled() {
        return this.remoteVerificationEnabled;
    }

    public void rexec(String user, String password, String command) throws IOException {
        this.rexec(user, password, command, false);
    }

    public void rexec(String user, String password, String command, boolean separateErrorStream) throws IOException {
        if (separateErrorStream) {
            this._errorStream_ = this.createErrorStream();
        } else {
            this._output_.write(0);
        }
        this._output_.write(user.getBytes(this.getCharset()));
        this._output_.write(0);
        this._output_.write(password.getBytes(this.getCharset()));
        this._output_.write(0);
        this._output_.write(command.getBytes(this.getCharset()));
        this._output_.write(0);
        this._output_.flush();
        int ch = this._input_.read();
        if (ch > 0) {
            StringBuilder buffer = new StringBuilder();
            while ((ch = this._input_.read()) != -1 && ch != 10) {
                buffer.append((char)ch);
            }
            throw new IOException(buffer.toString());
        }
        if (ch < 0) {
            throw new IOException("Server closed connection.");
        }
    }

    public final void setRemoteVerificationEnabled(boolean enable) {
        this.remoteVerificationEnabled = enable;
    }
}

