/*
 * Decompiled with CFR 0.152.
 */
package nlc.lib.doc.shape;

import java.awt.Color;
import java.io.Serializable;
import jp.co.extreme.doc.util.DcfConstants;
import nlc.lib.doc.shape.DcfAbstractShape;
import nlc.lib.doc.shape.DcfRectangle2D;

public class DcfRectangleShape
extends DcfAbstractShape
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6842804880160521574L;
    protected DcfRectangle2D rectangle;
    public double lineWidth;
    public String lineType;
    public Color lineColor;
    public boolean isFill;
    public Color fillColor;
    public double hatchingDot;
    public double hatchingConcentration;
    public Color hatchingColor;

    public DcfRectangleShape() throws Exception {
        this.clear();
    }

    public DcfRectangleShape(String name, double x, double y, double w, double h) throws Exception {
        this.name = name;
        this.rectangle.x = x;
        this.rectangle.y = y;
        this.rectangle.height = w;
        this.rectangle.width = h;
    }

    @Override
    public void clear() throws Exception {
        super.clear();
        this.setRectangle(new DcfRectangle2D());
        this.lineWidth = 0.0;
        this.lineType = null;
        this.lineColor = null;
        this.isFill = false;
        this.fillColor = null;
        this.setLine(false);
        this.hatchingDot = 0.0;
        this.hatchingConcentration = 0.0;
        this.hatchingColor = null;
    }

    @Override
    public void setX(double x) throws Exception {
        this.rectangle.x = x;
    }

    @Override
    public double getX() throws Exception {
        return this.rectangle.x;
    }

    @Override
    public void setY(double y) throws Exception {
        this.rectangle.y = y;
    }

    @Override
    public double getY() throws Exception {
        return this.rectangle.y;
    }

    public DcfRectangle2D getRectangle() throws Exception {
        return this.rectangle;
    }

    public void setRectangle(DcfRectangle2D rectangle) throws Exception {
        this.rectangle = rectangle;
    }

    public void setRect(double x, double y, double width, double height) throws Exception {
        this.rectangle.setRect(x, y, width, height);
    }

    public void setWidth(double width) throws Exception {
        this.rectangle.width = width;
    }

    public void setHeight(double height) throws Exception {
        this.rectangle.height = height;
    }

    public double setLine(boolean bool) throws Exception {
        if (bool) {
            this.lineWidth = 0.6;
            this.lineType = DcfConstants.DEFAULT_lineType;
            this.lineColor = DcfConstants.DEFAULT_LINE_COLOR;
        } else {
            this.lineWidth = 0.0;
            this.lineColor = DcfConstants.DEFAULT_LINE_COLOR;
        }
        return this.rectangle.height;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DcfRectangleShape obj = null;
        try {
            obj = (DcfRectangleShape)super.clone();
            obj.setRectangle((DcfRectangle2D)this.rectangle.clone());
        }
        catch (Exception ex) {
            throw new CloneNotSupportedException(ex.getMessage());
        }
        return obj;
    }
}

