/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.web.javascript;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.io.BcStreamUtil;

public class WbfNewJsUtil {
    static Map<String, String> scriptMap = new HashMap<String, String>();

    private WbfNewJsUtil() {
    }

    public static String getScript(InputStream is) throws Exception {
        byte[] bytes = BcStreamUtil.readWithClose(is);
        return new String(bytes, BcConstants.charset.name());
    }

    public static String getScriptWithTag(InputStream is) throws Exception {
        return WbfNewJsUtil.addTag(WbfNewJsUtil.getScript(is));
    }

    public static String addTag(String script) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<script>\n");
        sb.append(script);
        sb.append("\n</script>\n");
        return sb.toString();
    }

    public static String getScript(ScriptType scriptType) throws Exception {
        String script = scriptMap.get(scriptType.name());
        if (script == null) {
            script = WbfNewJsUtil.getScript(WbfNewJsUtil.class.getResourceAsStream(scriptType.fileName));
            scriptMap.put(scriptType.name(), script);
        }
        String scriptWk = script;
        return scriptWk;
    }

    public static String locationChangeJs(String selector) throws Exception {
        String script = WbfNewJsUtil.getScript(ScriptType.location_change);
        script = script.replace("${selector}", selector);
        return script;
    }

    public static enum ScriptType {
        location_change("location_change.js");

        public final String fileName;

        private ScriptType(String fileName) {
            this.fileName = fileName;
        }
    }
}

