/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swt;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class SwtImageUtil {
    public static BufferedImage convertToAwt(ImageData swtImageData) {
        ColorModel colorModel = null;
        PaletteData palette = swtImageData.palette;
        if (palette.isDirect) {
            colorModel = new DirectColorModel(swtImageData.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(swtImageData.width, swtImageData.height), false, null);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            int y = 0;
            while (y < swtImageData.height) {
                int x = 0;
                while (x < swtImageData.width) {
                    int pixel = swtImageData.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    pixelArray[0] = rgb.red;
                    pixelArray[1] = rgb.green;
                    pixelArray[2] = rgb.blue;
                    raster.setPixels(x, y, 1, 1, pixelArray);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = swtImageData.transparentPixel != -1 ? new IndexColorModel(swtImageData.depth, rgbs.length, red, green, blue, swtImageData.transparentPixel) : new IndexColorModel(swtImageData.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(swtImageData.width, swtImageData.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < swtImageData.height) {
            int x = 0;
            while (x < swtImageData.width) {
                int pixel;
                pixelArray[0] = pixel = swtImageData.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    public static ImageData convertToSwt(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    int pixel = palette.getPixel(new RGB(pixelArray[0], pixelArray[1], pixelArray[2]));
                    data.setPixel(x, y, pixel);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }
}

