/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.swing.SwgPanel;

public class SwgImagePanel
extends SwgPanel {
    private static final long serialVersionUID = -589001824669081504L;
    protected Image image;
    protected boolean keepRatio;
    protected boolean isScaling;
    protected int imageWidth;
    protected int imageHeight;
    protected int imageWidth2;
    protected int imageHeight2;
    protected BcMonitor monitor;
    protected boolean monitorFlag;
    public boolean fitToImage;

    public SwgImagePanel(Image image) {
        this.setImage(image);
    }

    public SwgImagePanel() {
        this((Image)null);
    }

    public void setKeepRatio(boolean keepRatio) {
        this.keepRatio = keepRatio;
    }

    public void setScaling(boolean isScaling) {
        this.isScaling = isScaling;
    }

    public void setImage(Image image) {
        this.image = image;
        if (this.fitToImage) {
            this.setPreferredSize(new Dimension(image.getWidth(null), image.getHeight(null)));
        }
        this.repaint();
    }

    public Image getImage() {
        return this.image;
    }

    public void setMonitor(BcMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void repaint() {
        this.monitorFlag = false;
        super.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.image == null) {
            return;
        }
        if (!this.monitorFlag) {
            if (this.monitor != null) {
                this.monitor.lock();
            }
            this.monitorFlag = true;
        }
        if (this.isScaling) {
            if (this.keepRatio) {
                this.imageWidth = this.image.getWidth(null);
                this.imageHeight = this.image.getHeight(null);
                double magnification = (double)this.getWidth() / (double)this.imageWidth;
                this.imageWidth2 = (int)((double)this.imageWidth * magnification);
                this.imageHeight2 = (int)((double)this.imageHeight * magnification);
                if (this.imageHeight2 > this.getHeight()) {
                    magnification = (double)this.getHeight() / (double)this.imageHeight;
                    this.imageWidth2 = (int)((double)this.imageWidth * magnification);
                    this.imageHeight2 = (int)((double)this.imageHeight * magnification);
                }
                int tx = (this.getWidth() - this.imageWidth2) / 2;
                int ty = (this.getHeight() - this.imageHeight2) / 2;
                g.drawImage(this.image, tx, ty, this.imageWidth2, this.imageHeight2, this);
            } else {
                g.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        } else {
            g.drawImage(this.image, 0, 0, this);
        }
    }

    @Override
    public boolean imageUpdate(Image image, int infoflags, int x, int y, int width, int height) {
        if (infoflags == 32 && this.monitor != null) {
            this.monitor.unLock();
        }
        return super.imageUpdate(image, infoflags, x, y, width, height);
    }
}

