/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf8.swg;

import java.awt.event.ComponentEvent;
import java.util.Properties;
import javax.swing.JLabel;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.sql.SqlConstants;
import jp.co.extreme.swing.SwgComboBox;
import jp.co.extreme.swing.SwgPanel;
import jp.co.extreme.swing.SwgUtil;

public class HswgDatasourcePanel
extends SwgPanel {
    private static final long serialVersionUID = -7304343189359069672L;
    public SwgComboBox dbDriverComboBox;
    public SwgComboBox dbUrlComboBox;
    public SwgComboBox dbUserComboBox;
    public SwgComboBox dbPasswordComboBox;

    public HswgDatasourcePanel(String title) throws Exception {
        this.setBorderTitle(title);
        this.dbDriverComboBox = new SwgComboBox();
        this.dbDriverComboBox.setEditable(true);
        this.dbUrlComboBox = new SwgComboBox();
        this.dbUrlComboBox.setEditable(true);
        this.dbUserComboBox = new SwgComboBox();
        this.dbUserComboBox.setEditable(true);
        this.dbPasswordComboBox = new SwgComboBox();
        this.dbPasswordComboBox.setEditable(true);
        this.initComponent();
    }

    public HswgDatasourcePanel() throws Exception {
        this.dbDriverComboBox = new SwgComboBox();
        this.dbDriverComboBox.setEditable(true);
        this.dbUrlComboBox = new SwgComboBox();
        this.dbUrlComboBox.setEditable(true);
        this.dbUserComboBox = new SwgComboBox();
        this.dbUserComboBox.setEditable(true);
        this.dbPasswordComboBox = new SwgComboBox();
        this.dbPasswordComboBox.setEditable(true);
        this.initComponent();
    }

    @Override
    public void componentResized(ComponentEvent ev) {
        this.initComponent();
    }

    protected void initComponent() {
        int rowHeight = SwgUtil.getTextFieldHeight(this.getFont(), null);
        int rowGap = SwgUtil.getRowDiff(this.getFont());
        int colGap = SwgUtil.getColDiff(this.getFont());
        int c1x = 0;
        int c1w = 120;
        int c2x = c1x + c1w + colGap;
        int ly = rowHeight;
        int field1Width = this.getWidth() - c1w - colGap * 4;
        SwgUtil.setLocation(this, new JLabel("JDBC Driver", 4), (double)c1x, (double)ly, (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this, this.dbDriverComboBox, (double)c2x, (double)ly, (double)field1Width, (double)rowHeight);
        SwgUtil.setLocation(this, new JLabel("Data Source URL", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this, this.dbUrlComboBox, (double)c2x, (double)ly, (double)field1Width, (double)rowHeight);
        SwgUtil.setLocation(this, new JLabel("User", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this, this.dbUserComboBox, (double)c2x, (double)ly, 200.0, (double)rowHeight);
        SwgUtil.setLocation(this, new JLabel("Password", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this, this.dbPasswordComboBox, (double)c2x, (double)ly, 200.0, (double)rowHeight);
        this.validate();
    }

    public Properties getParameter() {
        Properties props = new Properties();
        String propVal = (String)this.dbDriverComboBox.getSelectedItem();
        if (!BcStringUtil.isEmpty(propVal)) {
            props.setProperty(SqlConstants.DataSourceProperty.driver.name(), propVal);
        }
        if (!BcStringUtil.isEmpty(propVal = (String)this.dbUrlComboBox.getSelectedItem())) {
            props.setProperty(SqlConstants.DataSourceProperty.url.name(), propVal);
        }
        if (!BcStringUtil.isEmpty(propVal = (String)this.dbUserComboBox.getSelectedItem())) {
            props.setProperty(SqlConstants.DataSourceProperty.user.name(), propVal);
        }
        if (!BcStringUtil.isEmpty(propVal = (String)this.dbPasswordComboBox.getSelectedItem())) {
            props.setProperty(SqlConstants.DataSourceProperty.password.name(), propVal);
        }
        return props;
    }

    public void setParameter(Properties props) {
        this.dbDriverComboBox.setSelectedItem(props.getProperty(SqlConstants.DataSourceProperty.driver.name()));
        this.dbUrlComboBox.setSelectedItem(props.getProperty(SqlConstants.DataSourceProperty.url.name()));
        this.dbUserComboBox.setSelectedItem(props.getProperty(SqlConstants.DataSourceProperty.user.name()));
        this.dbPasswordComboBox.setSelectedItem(props.getProperty(SqlConstants.DataSourceProperty.password.name()));
    }
}

