/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf6.fx;

import java.io.File;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javax.swing.table.TableModel;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableContext;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.poi.PoiUtil;
import jp.co.extreme.scf.util.ScfFileUtil;
import jp.co.extreme.scf4.fx.HfxExportWizard;
import jp.co.extreme.scf4.fx.TmpEvent;
import jp.co.extreme.scf4.table.ScfDisplayContext;
import jp.co.extreme.scf6.fx.JfxDisplayContextPane;

public class JfxTableControlPane
extends FxDecoratePane {
    protected BcTableColumnModel swgTableColumnModel;
    protected TableModel swgTableModel;
    protected BcTableContext tableContext;
    protected Button exportButton;
    protected Button displaySettingButton;
    protected String title;
    protected ScfDisplayContext displayContextOrigin;
    protected int groupNumber = 0;

    public JfxTableControlPane() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.getControlPane().setAlignmentPos(Pos.CENTER_LEFT);
        this.setPrefHeight(24.0);
        this.initControl();
    }

    protected void initControl() throws Exception {
        this.exportButton = new FxButton();
        this.exportButton.setOnAction(this.actionEventHandler);
        this.exportButton.setGraphic((Node)FxImageHelper.createImageView_icon("export_64x64.png"));
        this.exportButton.setTooltip(new Tooltip(BcWords.getInstance().export));
        this.getControlPane().addControl(this.groupNumber, (Node)this.exportButton);
    }

    public void setData(BcTableColumnModel swgTableColumnModel, TableModel swgTableModel, BcTableContext tableContext) throws Exception {
        this.swgTableColumnModel = swgTableColumnModel;
        this.swgTableModel = swgTableModel;
        this.tableContext = tableContext;
        if (tableContext != null) {
            this.setTitle(tableContext.tableName);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.exportButton) {
            String filePath = ScfFileUtil.createFilePath(this.getTitle());
            HfxExportWizard exportWizard = new HfxExportWizard();
            exportWizard.setCondition(PoiUtil.createExportCondition(), this.swgTableColumnModel, this.swgTableModel, new File(filePath));
            exportWizard.show(this.getScene().getWindow());
        } else if (ev.getSource() == this.displaySettingButton) {
            this.displaySettingButtonAction();
        }
    }

    public void setDisplaySettingButton(boolean disp) throws Exception {
        if (disp && this.displaySettingButton == null) {
            this.displaySettingButton = new FxButton();
            this.displaySettingButton.setOnAction(this.actionEventHandler);
            this.displaySettingButton.setGraphic((Node)FxImageHelper.createImageView_icon("gear_64x64.png"));
            this.displaySettingButton.setTooltip(new Tooltip(BcWords.getInstance().configuration));
            this.getControlPane().addControl(this.groupNumber, (Node)this.displaySettingButton);
        } else if (this.displaySettingButton != null) {
            this.getControlPane().removeControl((Node)this.displaySettingButton);
        }
    }

    protected void displaySettingButtonAction() throws Exception {
        JfxDisplayContextPane displayContextPane = new JfxDisplayContextPane();
        displayContextPane.tableDisplayContextPanel.setTargetData(this.swgTableColumnModel, this.tableContext.title, this.displayContextOrigin);
        ScfDisplayContext displayContext = displayContextPane.show(FxUtil.getWindow((Node)this));
        if (displayContext != null) {
            TmpEvent tmpEvent = new TmpEvent((Object)this, TmpEvent.EventType.displayContextChanged);
            tmpEvent.setUserObject(displayContext);
        }
    }
}

