/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.swg;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.table.TableModel;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.poi.PoiExportEventHandler;
import jp.co.extreme.poi.PoiWords;
import jp.co.extreme.scf4.swg.HswgExportWizerd;
import jp.co.extreme.swing.SwgDecoratePanel;
import jp.co.extreme.swing.SwgFrame;
import jp.co.extreme.swing.SwgOptionPane;
import jp.co.extreme.swing.SwgProgressBar;
import jp.co.extreme.swing.SwgUtil;

public class HswgExportProcessiongPanel
extends SwgDecoratePanel
implements PoiExportEventHandler {
    private static final long serialVersionUID = 6912339374123465999L;
    protected HswgExportWizerd exportWizerd;
    protected SwgProgressBar progressBar = new SwgProgressBar();
    long startMillis = -1L;
    protected Window window;

    public HswgExportProcessiongPanel(HswgExportWizerd exportWizerd) throws Exception {
        this.exportWizerd = exportWizerd;
        exportWizerd.csvWriter.addExportEventHandler(this);
        this.setBorderSize(80, 40, 10, 10);
        String msg = String.format(PoiWords.getInstance().Outputting_destination_$, exportWizerd.destFilePath);
        this.setDescription(msg, 80);
        this.initComponent();
    }

    protected void initComponent() {
        int rowHeight = SwgUtil.getTextFieldHeight(this.getFont(), null);
        int rowGap = SwgUtil.getRowDiff(this.getFont());
        int colGap = SwgUtil.getColDiff(this.getFont());
        int c1x = 0;
        int c1w = 120;
        int c2x = c1x + c1w + colGap;
        int ly = rowHeight;
        SwgUtil.setLocation(this.centerPanel, this.progressBar, (double)(c1x + 40), (double)ly, 430.0, (double)rowHeight);
        ly += rowHeight + rowGap;
        ly += rowHeight + rowGap;
    }

    @Override
    public void rowExported(TableModel tableModel, int rowId) throws Exception {
        if (this.startMillis < 0L) {
            this.startMillis = System.currentTimeMillis();
        }
        if (rowId % 10 != 0) {
            return;
        }
        this.progressBar.setMaximum(tableModel.getRowCount());
        int rowCount = rowId + 1;
        this.progressBar.setValue(rowCount);
        double progressPer = (double)rowCount / (double)tableModel.getRowCount() * 100.0;
        long period = System.currentTimeMillis() - this.startMillis;
        double restTime = (double)period / progressPer * (100.0 - progressPer);
        String restTimeStr = BcTimeUtil.toDurationString((long)restTime);
    }

    @Override
    public void close() {
        this.window.dispose();
    }

    public void showAsFrame() throws Exception {
        final SwgFrame frame = new SwgFrame();
        frame.getContentPane().add((Component)this, "Center");
        frame.setResizable(false);
        frame.setDefaultCloseOperation(0);
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ev) {
                try {
                    HswgExportProcessiongPanel.this.exportWizerd.doExport2();
                    String msg = String.format(PoiWords.getInstance().Output_completed_destination_$, HswgExportProcessiongPanel.this.exportWizerd.destFilePath);
                    SwgOptionPane.showMessageDialog(frame, msg, BcWords.getInstance().information, 1);
                    HswgExportProcessiongPanel.this.close();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                    SwgOptionPane.showMessageDialog(frame, ex, BcWords.getInstance().error, 0);
                    HswgExportProcessiongPanel.this.close();
                }
            }
        });
        frame.setTitle(BcWords.getInstance().export);
        frame.setIconImage(AwtImageHelper.getWindowIconImage());
        this.window = frame;
        SwgUtil.setCenter(this.window, 580.0, 320.0);
        this.window.setVisible(true);
    }
}

