/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.scf4.model.ScfPropertyElement;

public class ScfPropertyMap
implements Serializable {
    private static final long serialVersionUID = 6219356054566939133L;
    public static final int DEFAULT_INDEX = 1;
    protected Map<String, Map<Integer, Object>> map = new HashMap<String, Map<Integer, Object>>();

    public ScfPropertyMap() {
        this.clear();
    }

    public void clear() {
        this.map.clear();
    }

    public Map<Integer, Object> put(String key, int index, Object value) throws Exception {
        Map<Integer, Object> valueMap = this.map.get(key);
        if (valueMap == null) {
            valueMap = new HashMap<Integer, Object>();
            this.map.put(key, valueMap);
        }
        valueMap.put(index, value);
        return valueMap;
    }

    public Map<Integer, Object> put(String key, Object value) throws Exception {
        return this.put(key, 1, value);
    }

    public String getValue(String key, int index, Object defaultValue) throws Exception {
        Map<Integer, Object> valueMap = this.map.get(key);
        if (valueMap == null) {
            return BcStringUtil.toString(defaultValue);
        }
        if (valueMap.containsKey(index)) {
            Object value = valueMap.get(index);
            return BcStringUtil.toString(value);
        }
        return BcStringUtil.toString(defaultValue);
    }

    public String getValue(String key, Object defaultValue) throws Exception {
        return this.getValue(key, 1, defaultValue);
    }

    public String getValue(String key) throws Exception {
        return this.getValue(key, null);
    }

    public void putAll(Collection<ScfPropertyElement> propertyElementCollection) throws Exception {
        for (ScfPropertyElement propertyElement : propertyElementCollection) {
            this.put(propertyElement.key, propertyElement.index, propertyElement.value);
        }
    }
}

