/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.fx;

import java.io.File;
import java.util.Locale;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import jp.co.extreme.base.charset.BcCharsetNames;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcInputValidator;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxCheckBox;
import jp.co.extreme.fx.control.FxComboBox;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.poi.PoiConstants;
import jp.co.extreme.poi.PoiExportCondition;
import jp.co.extreme.poi.PoiUtil;
import jp.co.extreme.poi.PoiWords;
import jp.co.extreme.scf4.fx.HfxExportWizard;
import jp.co.extreme.scf4.fx.XdtsWizardPane;

class HfxExportConditionPane
extends XdtsWizardPane {
    protected FxFlowPane centerPane = new FxFlowPane(11);
    protected FxTextField filePathField = new FxTextField();
    protected FxButton fileChooseButton = FxUtil.createBrowsButton(null);
    protected FileChooser fileChooser = new FileChooser();
    protected FxComboBox<String> formatTypeComboBox = new FxComboBox();
    protected FxComboBox<String> fieldSeparatorComboBox = new FxComboBox();
    protected FxComboBox<String> lineSeparatorComboBox = new FxComboBox();
    protected FxComboBox quotationMarkPolicyComboBox = new FxComboBox();
    protected FxCheckBox headerEnabledCheckBox = new FxCheckBox();
    protected FxComboBox<String> encodingComboBox = new FxComboBox();
    protected FxLabel bomLabel;
    protected FxCheckBox bomCheckBox;
    protected FxCheckBox codeMapCheckBox;
    protected FxCheckBox notVisibleCheckBox;
    protected PoiExportCondition exportCondition;
    protected HfxExportWizard wizard;

    public HfxExportConditionPane(HfxExportWizard wizard) throws Exception {
        this.bomLabel = new FxLabel(BcWords.getInstance().bom);
        this.bomCheckBox = new FxCheckBox();
        this.codeMapCheckBox = new FxCheckBox();
        this.notVisibleCheckBox = new FxCheckBox();
        this.wizard = wizard;
        this.setComponant();
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setComponant() throws Exception {
        this.mainDecoratePane.setCenter((Node)this.centerPane);
        this.filePathField.setPrefColumnCount(90);
        this.fileChooseButton.setOnAction(this.actionEventHandler);
        FxNodeUnit controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().destination), new Node[]{this.filePathField, this.fileChooseButton});
        this.centerPane.addNodeUnit(controlUnit);
        this.formatTypeComboBox.getItems().add((Object)BcWords.getInstance().csv);
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().format), new Node[]{this.formatTypeComboBox});
        Enum[] enumArray = PoiConstants.FieldSeparator.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            PoiConstants.FieldSeparator fieldSeparator = enumArray[n2];
            this.fieldSeparatorComboBox.getItems().add((Object)fieldSeparator.note);
            ++n2;
        }
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().fieldSeparator), new Node[]{this.fieldSeparatorComboBox});
        this.centerPane.addNodeUnit(controlUnit);
        enumArray = BcStringUtil.LineSeparator.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum lineSeparator = enumArray[n2];
            this.lineSeparatorComboBox.getItems().add((Object)((BcStringUtil.LineSeparator)lineSeparator).note);
            ++n2;
        }
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().lineSeparator), new Node[]{this.lineSeparatorComboBox});
        this.centerPane.addNodeUnit(controlUnit);
        this.quotationMarkPolicyComboBox.getItems().add((Object)PoiConstants.QuotationMarkPolicy.necessary.note);
        this.quotationMarkPolicyComboBox.getItems().add((Object)PoiConstants.QuotationMarkPolicy.always.note);
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().quotationMark), new Node[]{this.quotationMarkPolicyComboBox});
        this.centerPane.addNodeUnit(controlUnit);
        controlUnit = new FxNodeUnit((Node)new FxLabel(PoiWords.getInstance().header_output.toPlain()), new Node[]{this.headerEnabledCheckBox});
        this.centerPane.addNodeUnit(controlUnit);
        int i = 0;
        while (i < PoiUtil.charsetListDefault.size()) {
            String charsetName = PoiUtil.charsetListDefault.get(i);
            this.encodingComboBox.getItems().add((Object)charsetName);
            ++i;
        }
        this.encodingComboBox.setOnAction(this.actionEventHandler);
        this.bomSetting();
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().encoding), new Node[]{this.encodingComboBox});
        this.centerPane.addNodeUnit(controlUnit);
        controlUnit = new FxNodeUnit((Node)this.bomLabel, new Node[]{this.bomCheckBox});
        this.centerPane.addNodeUnit(controlUnit);
        controlUnit = new FxNodeUnit((Node)new FxLabel(PoiWords.getInstance().constant_conversion.toPlain()), new Node[]{this.codeMapCheckBox});
        this.centerPane.addNodeUnit(controlUnit);
        controlUnit = new FxNodeUnit((Node)new FxLabel(PoiWords.getInstance().invisible_column_output.toPlain()), new Node[]{this.notVisibleCheckBox});
        this.centerPane.addNodeUnit(controlUnit);
        this.nextButton.setText(BcWords.getInstance().execute);
        this.nextButton.setVisible(true);
        this.cancelButton.setVisible(true);
    }

    public void bomSetting() {
        boolean isUtf8 = BcStringUtil.equalsIgnoreCase((String)this.encodingComboBox.getValue(), BcCharsetNames.UTF_8.value);
        this.bomCheckBox.setDisable(!isUtf8);
        this.bomLabel.setDisable(!isUtf8);
    }

    public void setDataModel(PoiExportCondition exportCondition) throws Exception {
        this.exportCondition = exportCondition;
        this.fieldSeparatorComboBox.getSelectionModel().select((Object)PoiConstants.FieldSeparator.getNoteBySeparator(exportCondition.fieldSeparator));
        this.lineSeparatorComboBox.getSelectionModel().select((Object)BcStringUtil.LineSeparator.getNoteBySeparator(exportCondition.lineSeparator));
        if (exportCondition.quotationMarkPolicy == PoiConstants.QuotationMarkPolicy.always) {
            this.quotationMarkPolicyComboBox.getSelectionModel().select(1);
        } else {
            this.quotationMarkPolicyComboBox.getSelectionModel().select(0);
        }
        this.headerEnabledCheckBox.setSelected(exportCondition.headerEnabled);
        if (!BcStringUtil.isEmpty(exportCondition.encoding)) {
            this.encodingComboBox.getSelectionModel().select((Object)exportCondition.encoding);
        }
        this.bomCheckBox.setSelected(exportCondition.bomEnabled);
        this.codeMapCheckBox.setSelected(exportCondition.codeMapEnabled);
        this.notVisibleCheckBox.setSelected(exportCondition.notVisibleEnabled);
        if (this.wizard.destFile != null) {
            this.filePathField.setText(this.wizard.destFile.getPath());
        }
    }

    protected void storeToDataModel() throws Exception {
        this.exportCondition.fieldSeparator = PoiConstants.FieldSeparator.getSeparatorByNote((String)this.fieldSeparatorComboBox.getValue());
        this.exportCondition.lineSeparator = BcStringUtil.LineSeparator.getSeparatorByNote((String)this.lineSeparatorComboBox.getValue());
        this.exportCondition.quotationMarkPolicy = this.quotationMarkPolicyComboBox.getSelectionModel().selectedIndexProperty().get() == 1 ? PoiConstants.QuotationMarkPolicy.always : PoiConstants.QuotationMarkPolicy.necessary;
        this.exportCondition.headerEnabled = this.headerEnabledCheckBox.isSelected();
        this.exportCondition.encoding = (String)this.encodingComboBox.getValue();
        this.exportCondition.bomEnabled = this.bomCheckBox.isSelected();
        this.exportCondition.codeMapEnabled = this.codeMapCheckBox.isSelected();
        this.exportCondition.notVisibleEnabled = this.notVisibleCheckBox.isSelected();
        this.exportCondition.locale = Locale.getDefault();
    }

    protected BcResult validateInputValue() throws Exception {
        BcResult result = new BcResult();
        BcInputValidator inputValidator = BcInputValidator.getInstance();
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.fileChooseButton) {
            FxUtil.initFileChooser(this.fileChooser, this.filePathField.getText());
            File file = this.fileChooser.showSaveDialog(this.getScene().getWindow());
            if (file != null) {
                this.filePathField.setText(file.getPath());
            }
        } else if (ev.getSource() == this.encodingComboBox) {
            this.bomSetting();
        }
    }

    @Override
    protected void nextButtonAction() throws Exception {
        super.nextButtonAction();
        BcResult result = this.validateInputValue();
        if (result.hasError()) {
            String message = BcMessageCreator.getInstance().createMessage(result.getErrorList());
            return;
        }
        this.storeToDataModel();
        this.wizard.destFile = new File(this.filePathField.getText());
        this.wizard.phase2();
    }

    @Override
    protected void cancelButtonAction() throws Exception {
        this.wizard.close();
    }
}

