/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.fx;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.layout.FxTitledPane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;

public class HfxAbstractSearchPane
extends FxBorderPane {
    protected StackPane stackPane = new StackPane();
    protected SplitPane splitPane = new SplitPane();
    protected Pane bgPane = new Pane();
    protected FxBorderPane topPane = new FxBorderPane();
    protected FxTitledPane titledPane = new FxTitledPane();
    protected FxBorderPane conditionBasePane = new FxBorderPane();
    protected VBox controBasevbox = new VBox();
    protected FxFlowPane controlPane = new FxFlowPane(22);
    protected TabPane tabPane;
    protected FxButton executeButton;
    protected FxButton initializeButton;
    protected int tabCount;
    protected Object resVale;
    protected Stage stage;

    public HfxAbstractSearchPane() throws Exception {
        this.executeButton = new FxButton(BcWords.getInstance().execute);
        this.initializeButton = new FxButton(BcWords.getInstance().initialize);
        Pane leftPaddingPane = new Pane();
        leftPaddingPane.setPrefWidth(4.0);
        this.topPane.setLeft((Node)leftPaddingPane);
        Pane bottomPaddingPane = new Pane();
        bottomPaddingPane.setPrefHeight(2.0);
        this.topPane.setBottom((Node)bottomPaddingPane);
        this.topPane.setCenter((Node)this.titledPane);
        this.titledPane.setTitle(BcWords.getInstance().extractionCondition.toPlain());
        this.titledPane.setContentNode((Node)this.conditionBasePane);
        this.executeButton.setOnAction(this.actionEventHandler);
        this.executeButton.setGraphic((Node)FxImageHelper.createImageView_icon("bullet_triangle_blue_64x64.png"));
        FxNodeUnit controlUnit = new FxNodeUnit((Node)this.executeButton, new Node[0]);
        this.controlPane.addNodeUnit(controlUnit);
        this.controBasevbox.setPadding(new Insets(8.0, 16.0, 2.0, 2.0));
        this.controBasevbox.getChildren().add((Object)this.controlPane);
        this.topPane.setRight((Node)this.controBasevbox);
        this.topPane.setMinHeight(this.getConditionHeightMin());
        this.splitPane.setOrientation(Orientation.VERTICAL);
        this.splitPane.getItems().addAll((Object[])new Node[]{this.topPane, this.getTabPane()});
        this.initializeButton.setOnAction(this.actionEventHandler);
        controlUnit = new FxNodeUnit((Node)this.initializeButton, new Node[0]);
        this.optionControlSetup();
        this.stackPane.getChildren().addAll((Object[])new Node[]{this.bgPane});
        this.stackPane.getChildren().addAll((Object[])new Node[]{this.splitPane});
        this.setCenter((Node)this.stackPane);
        FxUtil.defaultInitialize((Node)this);
    }

    public Node getConditionNode() throws Exception {
        return this.conditionBasePane.getCenter();
    }

    public void setConditionNode(Node conditionNode) throws Exception {
        this.conditionBasePane.setCenter(conditionNode);
    }

    public String getTitle() throws Exception {
        return null;
    }

    protected void optionControlSetup() throws Exception {
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.executeButton) {
            BcResult result = this.validateCondition();
            if (result != null && result.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                FxOptionPane.showMessageDialog((Window)this.stage, (Object)msg, BcWords.getInstance().error, 0);
                return;
            }
            if (result != null && result.hasWarn()) {
                StringBuilder sb = new StringBuilder();
                sb.append(BcMessageCreator.getInstance().createMessage(result.getWarnList()));
                sb.append("\n\n");
                sb.append("\u7d9a\u884c\u3057\u307e\u3059\u304b\uff1f");
                if (FxOptionPane.showConfirmDialog((Window)this.stage, (Object)sb, BcWords.getInstance().warning, 2) != 0) {
                    return;
                }
            }
            if (result != null && result.hasInfo()) {
                String msg = BcMessageCreator.getInstance().createMessage(result.getInfoList());
                FxOptionPane.showMessageDialog((Window)this.stage, (Object)msg, BcWords.getInstance().information, 1);
            }
            this.doSerch();
        } else if (ev.getSource() == this.initializeButton) {
            this.clearCondition();
        }
    }

    protected TabPane getTabPane() throws Exception {
        if (this.tabPane == null) {
            this.tabPane = new TabPane();
            this.tabPane.setSide(Side.TOP);
            this.tabPane.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){

                public void changed(ObservableValue<? extends Tab> old, Tab oldTab, Tab newTab) {
                    try {
                        HfxAbstractSearchPane.this.tabSelected(newTab.getContent());
                    }
                    catch (Exception ex) {
                        HfxAbstractSearchPane.this.handleException(ex);
                    }
                }
            });
        }
        return this.tabPane;
    }

    protected void addTad(Node contentNode) throws Exception {
        ++this.tabCount;
        Tab tab = new Tab();
        tab.setText(String.valueOf(BcWords.getInstance().result) + this.tabCount);
        tab.setContent(contentNode);
        tab.setClosable(true);
        this.tabPane.getTabs().add((Object)tab);
        this.tabPane.getSelectionModel().select((Object)tab);
    }

    protected void tabSelected(Node contentNode) throws Exception {
    }

    protected BcResult validateCondition() throws Exception {
        return null;
    }

    public void doSerch() throws Exception {
    }

    public void clearCondition() throws Exception {
    }

    protected void setStageOption(Stage stage) throws Exception {
        stage.setTitle(this.getTitle());
        FxImageHelper.setStageIcon(stage);
    }

    protected void stageShown() throws Exception {
        double position = this.getConditionHeightDefault() / this.splitPane.getHeight();
        this.splitPane.setDividerPositions(new double[]{position});
    }

    protected double getConditionHeightMin() throws Exception {
        return 82.0;
    }

    protected double getConditionHeightDefault() throws Exception {
        return 130.0;
    }

    public void setupSize(Stage stage) throws Exception {
        FxUtil.setWindowCenter((Window)stage, 0.85f);
    }

    public void close() throws Exception {
        this.stage.close();
    }

    public Object show(Window ownerWindow, boolean doWait) throws Exception {
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    HfxAbstractSearchPane.this.stageShown();
                }
                catch (Exception ex) {
                    HfxAbstractSearchPane.this.handleException(ex);
                }
            }
        });
        this.stage.setResizable(true);
        if (!BcStringUtil.isEmpty(this.getTitle())) {
            this.stage.setTitle(this.getTitle());
        }
        FxImageHelper.setStageIcon(this.stage);
        this.setupSize(this.stage);
        if (doWait) {
            this.stage.showAndWait();
        } else {
            this.stage.show();
        }
        return this.resVale;
    }
}

