/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf3.server;

import java.util.List;
import java.util.Locale;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.datasource.util.EtcRsmdSupplement;
import jp.co.extreme.datasource.util.ScfMmdServerUtil;
import jp.co.extreme.scf.common.ScfHandle;
import jp.co.extreme.scf3.server.ScfAbstractQueryTask;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.SqlUtil;

public class ScfQueryTask
extends ScfAbstractQueryTask {
    public boolean canceled;
    public DtsSession dtsSession;
    public String query;
    public SqlStatement stmt;
    public Object result;
    public Locale locale;
    public DtsWordManager wordManager;
    public EtcRsmdSupplement rsmdSupplement;
    public List<String> tableColumnNameList;

    public Object taskProcess() throws Exception {
        List<String> sentenceList = SqlUtil.splitSentence(this.query);
        String sentence = null;
        Object tmpRes = null;
        int i = 0;
        while (i < sentenceList.size()) {
            sentence = sentenceList.get(i);
            boolean isResultSet = this.stmt.execute(sentence);
            if (isResultSet) {
                SqlResultSet rs = this.stmt.getResultSet();
                tmpRes = rs;
            } else {
                int updateCount = -1;
                if (this.stmt != null) {
                    updateCount = this.stmt.getUpdateCount();
                }
                if (updateCount >= 0) {
                    tmpRes = updateCount;
                } else {
                    this.canceled = true;
                    tmpRes = "Statement Timeout.";
                    this.getLogger().debug("ScfQueryTask:" + tmpRes);
                }
            }
            ++i;
        }
        if (tmpRes instanceof SqlResultSet) {
            SqlResultSet rs = (SqlResultSet)tmpRes;
            this.resultSetComplete(rs);
        } else {
            this.result = tmpRes;
        }
        if (this.canceled) {
            this.removeHandle();
        }
        return null;
    }

    public void resultSetComplete(SqlResultSet rs) throws Exception {
        this.tableColumnList = ScfMmdServerUtil.createTableColumnList(rs.getMetaData(), this.dtsSession.getSessionFactory().mmdFieldMap, this.wordManager, this.rsmdSupplement, this.locale, this.tableColumnNameList);
        this.result = rs;
    }

    @Override
    protected void handleException(Throwable throwable) {
        super.handleException(throwable);
        this.result = throwable;
        this.removeHandle();
    }

    public void removeHandle() {
        ScfHandle handle = this.getHandle();
        if (handle != null) {
            try {
                handle.getHandleManager().removeHandle(handle.getHandleId());
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
    }
}

