/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.rmi.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteOrder;
import jp.co.extreme.base.charset.BcCharsetNames;
import jp.co.extreme.base.core.BcByteUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcStreamTransmitter;
import jp.co.extreme.rmi.util.RmiSimpalePacket;

public final class RmiSocketUtil {
    public static final ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private static BcStreamTransmitter streamTransmitter = new BcStreamTransmitter();

    private RmiSocketUtil() {
    }

    public static ByteArrayOutputStream toByteArrayOutputStream(int command, byte[] dataBytes) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(BcByteUtil.toByteArray(command, byteOrder));
        if (dataBytes != null) {
            baos.write(BcByteUtil.toByteArray(dataBytes.length, byteOrder));
            baos.write(dataBytes);
        } else {
            baos.write(BcByteUtil.toByteArray(0, byteOrder));
        }
        return baos;
    }

    public static ByteArrayOutputStream toByteArrayOutputStream(RmiSimpalePacket simpalePacket) throws Exception {
        return RmiSocketUtil.toByteArrayOutputStream(simpalePacket.command, simpalePacket.dataBytes);
    }

    public static ByteArrayOutputStream toByteArrayOutputStream(int command, String str) throws Exception {
        byte[] dataBytes = null;
        if (!BcStringUtil.isEmpty(str)) {
            dataBytes = str.getBytes(BcCharsetNames.UTF_8.value);
        }
        return RmiSocketUtil.toByteArrayOutputStream(command, dataBytes);
    }

    public static RmiSimpalePacket readSimpalePacket(InputStream is) throws Exception {
        RmiSimpalePacket simpalePacket = new RmiSimpalePacket();
        byte[] commandBytes = new byte[4];
        int readCnt = is.read(commandBytes, 0, commandBytes.length);
        simpalePacket.command = BcByteUtil.toInt(commandBytes, byteOrder);
        byte[] dataSizeBytes = new byte[4];
        readCnt = is.read(dataSizeBytes, 0, dataSizeBytes.length);
        int dataSize = BcByteUtil.toInt(dataSizeBytes, byteOrder);
        if (dataSize > 0) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(dataSize);
            streamTransmitter.transmit(is, baos, dataSize);
            simpalePacket.dataBytes = baos.toByteArray();
        }
        return simpalePacket;
    }
}

