/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.rmi.server;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import jp.co.extreme.base.net.BcAddressPort;
import jp.co.extreme.base.net.BcNetUtil;
import jp.co.extreme.base.thread.BcThread;
import jp.co.extreme.rmi.agent.RmiAgentContext;
import jp.co.extreme.rmi.server.RmiAcceptThread;
import jp.co.extreme.rmi.server.RmiLogHandler;
import jp.co.extreme.rmi.server.RmiRedirector;
import jp.co.extreme.rmi.server.RmiRemoteAgent;

class RmiAcceptThread_L2
extends BcThread {
    private RmiAcceptThread acceptThread;
    private Socket socket;

    public RmiAcceptThread_L2(RmiAcceptThread acceptThread, Socket socket) throws Exception {
        this.acceptThread = acceptThread;
        this.socket = socket;
        this.setPriority(1);
    }

    @Override
    protected void run2() throws Exception {
        this.stopThread();
        ObjectInputStream objis = new ObjectInputStream(this.socket.getInputStream());
        String protocolVersion = (String)objis.readObject();
        this.getLogger().debug("protocolVersion=" + protocolVersion);
        if ("rmix_100".equals(protocolVersion)) {
            this.clientType_rmixClient(this.socket);
        } else if ("logger_100".equals(protocolVersion)) {
            this.getLogger().debug("acceptThread.rmiServer=" + this.acceptThread.rmiServer);
            this.getLogger().debug("acceptThread.rmiServer.logHandler=" + this.acceptThread.rmiServer.logHandler);
            RmiLogHandler logHandler = this.acceptThread.rmiServer.logHandler;
            logHandler.loggerClientAccepted(this.socket, objis);
        } else {
            ObjectOutputStream objos = new ObjectOutputStream(this.socket.getOutputStream());
            objos.writeObject(2);
            objos.writeObject("\u30d7\u30ed\u30c8\u30b3\u30eb\u30d0\u30fc\u30b8\u30e7\u30f3 " + protocolVersion + " \u306b\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
            objos.flush();
            objos.reset();
        }
    }

    protected void clientType_rmixClient(Socket socket) throws Exception {
        BcAddressPort redirectAddressPort = null;
        RmiRedirector redirector = this.acceptThread.rmiServer.getRedirector();
        if (redirector != null) {
            BcAddressPort remoteAddressPort = BcNetUtil.parseAddressPort(socket.getRemoteSocketAddress().toString());
            BcAddressPort exclusionAddressPort = new BcAddressPort();
            exclusionAddressPort.address = socket.getLocalAddress().getHostAddress();
            exclusionAddressPort.port = socket.getLocalPort();
            redirectAddressPort = redirector.getRedirect(remoteAddressPort.address, exclusionAddressPort);
        }
        ObjectOutputStream objos = new ObjectOutputStream(socket.getOutputStream());
        if (redirectAddressPort == null) {
            objos.writeObject(1);
            objos.flush();
            RmiAgentContext agentContext = new RmiAgentContext();
            RmiRemoteAgent remoteAgent = new RmiRemoteAgent(agentContext);
            remoteAgent.setSocket(socket);
            this.acceptThread.rmiServer.addRemoteAgent(remoteAgent);
        } else {
            String redirectUrl = String.valueOf(redirectAddressPort.address) + ":" + redirectAddressPort.port;
            this.getLogger().debug("redirectUrl=" + redirectUrl);
            objos.writeObject(71);
            objos.writeObject(redirectUrl);
            objos.flush();
        }
    }
}

