/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.poi;

import java.io.Serializable;
import jp.co.extreme.base.util.BcAbstractWords;
import jp.co.extreme.base.util.BcISO;
import jp.co.extreme.base.util.BcLocaleUtil;
import jp.co.extreme.base.util.BcWordPack;
import jp.co.extreme.base.util.BcWords;

public class PoiWords
extends BcAbstractWords
implements Serializable {
    private static final long serialVersionUID = -8782476558666149884L;
    private static final PoiWords en = new PoiWords();
    private static PoiWords ja;
    boolean lineBreak = true;
    boolean connectWord = false;
    public BcWordPack header_output;
    public BcWordPack constant_conversion;
    public BcWordPack invisible_column_output;
    public String Outputting_destination_$;
    public String Output_completed_destination_$;

    private PoiWords() {
        this.header_output = new BcWordPack(this.lineBreak, this.connectWord, BcWords.getInstance().header, BcWords.getInstance().output);
        this.constant_conversion = new BcWordPack(this.lineBreak, this.connectWord, BcWords.getInstance().constant, BcWords.getInstance().conversion);
        this.invisible_column_output = new BcWordPack(this.lineBreak, this.connectWord, BcWords.getInstance().invisible, BcWords.getInstance().column, BcWords.getInstance().output);
        this.Outputting_destination_$ = "Outputting\uff0e\uff0e\uff0e\ndestination=%s";
        this.Output_completed_destination_$ = "Output completed.\ndestination=%s";
        this.setIso639(BcISO.ISO_639.English);
    }

    public static PoiWords getInstance(String langageCode) {
        PoiWords words = en;
        if (BcISO.ISO_639.Japanese.code.equalsIgnoreCase(langageCode)) {
            if (ja == null) {
                ja = new PoiWords();
                ja.setJapanese();
            }
            words = ja;
        }
        return words;
    }

    public static PoiWords getInstance(BcAbstractWords words) {
        return PoiWords.getInstance(words.getIso639().code);
    }

    public static PoiWords getInstance() {
        return PoiWords.getInstance(BcLocaleUtil.getIso639().code);
    }

    public void setJapanese() {
        this.setIso639(BcISO.ISO_639.Japanese);
        String langageCode = this.getIso639().code;
        this.header_output = new BcWordPack(this.lineBreak, this.connectWord, BcWords.getInstance((String)langageCode).header, BcWords.getInstance((String)langageCode).output);
        this.constant_conversion = new BcWordPack(this.lineBreak, this.connectWord, BcWords.getInstance((String)langageCode).constant, BcWords.getInstance((String)langageCode).conversion);
    }
}

