/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.poi;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jp.co.extreme.base.charset.BcCharsetNames;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import jp.co.extreme.poi.PoiConstants;
import jp.co.extreme.poi.PoiExportCondition;

public final class PoiUtil {
    public static List<String> charsetListDefault = new ArrayList<String>();

    static {
        charsetListDefault.add(BcCharsetNames.UTF_8.value);
        charsetListDefault.add(BcCharsetNames.MS932.value);
        charsetListDefault.add(BcCharsetNames.SJIS.value);
        charsetListDefault.add(BcCharsetNames.EUC_JP.value);
        charsetListDefault.add(BcCharsetNames.Windows_31J.value);
        Charset defaultCharset = Charset.defaultCharset();
        if (!charsetListDefault.contains(defaultCharset.name())) {
            charsetListDefault.add(defaultCharset.name());
        }
    }

    private PoiUtil() {
    }

    public static void setDefault(PoiExportCondition exportCondition) {
        exportCondition.headerEnabled = true;
        exportCondition.fieldSeparator = PoiConstants.FieldSeparator.COMMA.separator;
        exportCondition.lineSeparator = BcRuntimeUtil.lineSeparator;
        exportCondition.lineSeparatorLast = true;
        exportCondition.quotationMarkPolicy = PoiConstants.QuotationMarkPolicy.necessary;
        exportCondition.encoding = BcCharsetNames.UTF_8.value;
        exportCondition.bomEnabled = true;
        exportCondition.locale = Locale.getDefault();
        exportCondition.codeMapEnabled = true;
        exportCondition.notVisibleEnabled = false;
    }

    public static PoiExportCondition createExportCondition() throws Exception {
        PoiExportCondition exportCondition = new PoiExportCondition();
        PoiUtil.setDefault(exportCondition);
        return exportCondition;
    }
}

