/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.pdf;

import jp.co.extreme.pdf.PdfProducer;
import jp.co.extreme.pdf.object.PdfFont;
import jp.co.extreme.pdf.object.PdfFontDescriptor;

public abstract class Type1Font
extends PdfFont {
    private static final long serialVersionUID = -748597595988236184L;
    protected int[] charWidthArray;
    protected PdfFontDescriptor fontDescriptor = new PdfFontDescriptor();
    protected String encoding;
    protected int firstChar;
    protected int lastChar;

    public Type1Font() {
        this.setSubType("Type1");
        this.setFirstChar(0);
        this.setFirstChar(255);
        this.setIsMultibyteFont(false);
    }

    protected PdfFontDescriptor getFontDescriptor() {
        return this.fontDescriptor;
    }

    protected void setCharWidthArray(int[] value) {
        this.charWidthArray = value;
    }

    @Override
    protected int getCharWidth(char ch) {
        if (this.getFirstChar() <= ch && ch <= this.getLastChar()) {
            return this.charWidthArray[ch - this.getFirstChar()];
        }
        return 0;
    }

    protected int getCharWidth(int index) {
        return this.charWidthArray[index];
    }

    protected String getEncoding() {
        return this.encoding;
    }

    protected int getFirstChar() {
        return this.firstChar;
    }

    protected int getLastChar() {
        return this.lastChar;
    }

    protected void setEncoding(String value) {
        this.encoding = value;
    }

    protected void setFirstChar(int value) {
        this.firstChar = value;
    }

    protected void setLastChar(int value) {
        this.lastChar = value;
    }

    protected String getWidths() {
        StringBuilder sb = new StringBuilder("[");
        int j = 0;
        int i = this.getFirstChar();
        while (i <= this.getLastChar()) {
            sb.append(" ");
            sb.append(new Integer(this.getCharWidth(j)).toString());
            ++j;
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected byte[] getObjectDetail() {
        return new String("<<\r\n/Type /Font\r\n/Name /F" + new Integer(this.getName()).toString() + "\r\n" + "/Subtype /" + this.getSubType() + "\r\n" + "/BaseFont /" + this.getBaseFont() + "\r\n" + "/FirstChar " + new Integer(this.getFirstChar()) + "\r\n" + "/LastChar " + new Integer(this.getLastChar()) + "\r\n" + "/Widths " + this.getWidths() + "\r\n" + "/Encoding /" + this.getEncoding() + "\r\n" + "/FontDescriptor " + new Integer(this.fontDescriptor.getObjectId()).toString() + " 0 R\r\n" + ">>\r\n").getBytes();
    }

    @Override
    public void setOwner(PdfProducer producer) {
        super.setOwner(producer);
        this.fontDescriptor.setOwner(producer);
    }
}

