/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.common;

import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.etc.util.EtcPagination;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.module.wbfw.container.WbfwWcbArgument;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;
import jp.co.extreme.module.xweb.common.XwebIconManager;
import jp.co.extreme.web.javascript.WbfJslUtil;

public abstract class XwebPaginationBuilder {
    public int zengo = 5;
    private HtmlBuilder htmlBuilder;

    public XwebPaginationBuilder() {
        this.setHtmlBuilder(HtmlBuilder.getInstance());
    }

    public void setHtmlBuilder(HtmlBuilder htmlBuilder) {
        this.htmlBuilder = htmlBuilder;
    }

    public StringBuilder create(WbfwWcbArgument wcbArg, EtcPagination pagination) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.htmlBuilder.div_start());
        sb.append(this.htmlBuilder.ul_start());
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = ExtwCssUtil.ExtwClass.extw_inline_block.className;
        sb.append(this.htmlBuilder.p(globalAttribute, String.valueOf(BcNumberUtil.toString(pagination.getDataCount())) + "\u4ef6", true, false));
        int pageCount = pagination.getPageCount();
        if (pageCount <= 1) {
            sb.append(this.htmlBuilder.ul_end());
            sb.append(this.htmlBuilder.div_end());
            return sb;
        }
        sb.append(HtmlConstants.HtmlSpecialCharacter.space.value);
        int pageStart = Math.max(pagination.getPageNum() - this.zengo, 1);
        int pageEnd = Math.min(pagination.getPageNum() + this.zengo, pageCount);
        boolean prevPageDisabled = false;
        if (pagination.getPageNum() <= 1) {
            prevPageDisabled = true;
        }
        sb.append(this.htmlBuilder.li_start(ExtwCssUtil.ExtwClass.extw_inline_block.className, null));
        String iconTag = XwebIconManager.createTag(XwebIconManager.WebIcon.angleLeft);
        String button = this.createButton(wcbArg, pagination.getPageNum() - 1, iconTag, prevPageDisabled, false);
        sb.append(button);
        sb.append(this.htmlBuilder.li_end());
        if (pageStart > 1) {
            sb.append(this.htmlBuilder.li_start(ExtwCssUtil.ExtwClass.extw_inline_block.className, null));
            button = this.createButton(wcbArg, 1, Integer.toString(1), false, false);
            sb.append(button);
            sb.append(this.htmlBuilder.li_end());
            if (pageStart - 1 > 1) {
                sb.append(this.htmlBuilder.p(globalAttribute, "...", true, false));
            }
        }
        int i = pageStart;
        while (i <= pageEnd) {
            if (i == pagination.getPageNum()) {
                sb.append(this.htmlBuilder.li_start(ExtwCssUtil.ExtwClass.extw_inline_block.className, null));
                button = this.createButton(wcbArg, i, Integer.toString(i), false, true);
                sb.append(button);
                sb.append(this.htmlBuilder.li_end());
            } else {
                sb.append(this.htmlBuilder.li_start(ExtwCssUtil.ExtwClass.extw_inline_block.className, null));
                button = this.createButton(wcbArg, i, Integer.toString(i), false, false);
                sb.append(button);
                sb.append(this.htmlBuilder.li_end());
            }
            ++i;
        }
        if (pageEnd < pageCount) {
            if (pageCount - pageEnd > 1) {
                sb.append(this.htmlBuilder.p(globalAttribute, "...", true, false));
            }
            sb.append(this.htmlBuilder.li_start(ExtwCssUtil.ExtwClass.extw_inline_block.className, null));
            button = this.createButton(wcbArg, pageCount, Integer.toString(pageCount), false, false);
            sb.append(button);
            sb.append(this.htmlBuilder.li_end());
        }
        boolean nextPageDisabled = false;
        if (pagination.getPageNum() >= pageCount) {
            nextPageDisabled = true;
        }
        sb.append(this.htmlBuilder.li_start(ExtwCssUtil.ExtwClass.extw_inline_block.className, null));
        iconTag = XwebIconManager.createTag(XwebIconManager.WebIcon.angleRight);
        button = this.createButton(wcbArg, pagination.getPageNum() + 1, iconTag, nextPageDisabled, false);
        sb.append(button);
        sb.append(this.htmlBuilder.li_end());
        sb.append(this.htmlBuilder.ul_end());
        sb.append(this.htmlBuilder.div_end());
        return sb;
    }

    protected String createButton(WbfwWcbArgument wcbArg, int pageNo, String html, boolean disabled, boolean selected) throws Exception {
        String onclickAction = null;
        if (!disabled) {
            String href = this.createHref(wcbArg, pageNo);
            onclickAction = WbfJslUtil.locationHref(href);
        }
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = selected ? "page_button_selected" : "page_button";
        StringBuilder sb = new StringBuilder(this.htmlBuilder.button_start(globalAttribute, HtmlConstants.HtmlButtonType.button, null, null, disabled, onclickAction));
        sb.append(html);
        sb.append(this.htmlBuilder.button_end());
        return sb.toString();
    }

    protected abstract String createHref(WbfwWcbArgument var1, int var2) throws Exception;
}

