/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xwdl.fx;

import java.io.File;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxTabPane;
import jp.co.extreme.fx.extension.FxxAbstractDesktopPane;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.fx.viewer.FxxGeneralContentGroup;
import jp.co.extreme.fx.viewer.FxxViwerDesktopPane;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xwdl.fx.XwdlCondition;
import jp.co.extreme.module.xwdl.fx.XwdlDownloadEventHandler;
import jp.co.extreme.module.xwdl.fx.XwdlDownloadUrlTablePane;
import jp.co.extreme.module.xwdl.fx.XwdlDownlodTask;
import jp.co.extreme.module.xwdl.fx.XwdlElemnt;
import jp.co.extreme.module.xwdl.fx.XwdlHtmlParseTask;
import jp.co.extreme.module.xwdl.fx.XwdlParseUrlTablePane;
import jp.co.extreme.module.xwdl.fx.XwdlUrlEditPane;

public class XwdlDownloadPane
extends FxxAbstractDesktopPane {
    FxBorderPane borderPane1 = new FxBorderPane();
    FxFlowPane controlPane = new FxFlowPane(21);
    FxButton startButton = new FxButton();
    FxButton stopButton = new FxButton();
    FxButton addUrlButton = new FxButton();
    SplitPane splitPane1 = new SplitPane();
    FxTabPane tabPane1 = new FxTabPane();
    MenuItem closeMenuItem;
    XwdlParseUrlTablePane parseUrlTablePane;
    XwdlDownloadUrlTablePane downloadUrlTablePane;
    XwdlDownloadEventHandler downloadEventHandler;
    FxxViwerDesktopPane viwerDesktopPane;
    FxxGeneralContentGroup generalContentGroup;
    XwdlCondition xwdlCondition;

    public XwdlDownloadPane() throws Exception {
        Future future;
        ExecutorService executorService;
        this.closeMenuItem = new MenuItem(BcWords.getInstance().close);
        this.parseUrlTablePane = new XwdlParseUrlTablePane();
        this.downloadUrlTablePane = new XwdlDownloadUrlTablePane();
        this.downloadEventHandler = new InnerDownloadManager();
        this.xwdlCondition = new XwdlCondition();
        this.xwdlCondition.parseTaskMax = 20;
        this.xwdlCondition.loadTaskMax = 20;
        this.xwdlCondition.setDestDir(new File("Y://temp/zdownload/"));
        this.xwdlCondition.setup();
        int i = 0;
        while (i < this.xwdlCondition.parseTaskMax) {
            executorService = Executors.newCachedThreadPool();
            XwdlHtmlParseTask htmlParseTask = new XwdlHtmlParseTask(this.downloadEventHandler, this.xwdlCondition);
            future = executorService.submit(htmlParseTask);
            ++i;
        }
        i = 0;
        while (i < this.xwdlCondition.loadTaskMax) {
            executorService = Executors.newCachedThreadPool();
            XwdlDownlodTask downlodTask = new XwdlDownlodTask(this.downloadEventHandler, this.xwdlCondition);
            future = executorService.submit(downlodTask);
            ++i;
        }
    }

    protected void setContents() throws Exception {
        this.startButton.setOnAction(this.actionEventHandler);
        this.startButton.setText(BcWords.getInstance().start);
        this.startButton.setGraphic((Node)FxImageHelper.createImageView_icon("bullet_triangle_blue_64x64.png"));
        this.startButton.setTooltip(new Tooltip(XdtsWords.getInstance().TOOL_TIP_queryButton));
        FxNodeUnit nodeUnit = new FxNodeUnit(null, new Node[]{this.startButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.borderPane1.setCenter((Node)this.controlPane);
        this.stopButton.setOnAction(this.actionEventHandler);
        this.stopButton.setText(BcWords.getInstance().stop);
        this.stopButton.setGraphic((Node)FxImageHelper.createImageView_icon("sign_forbidden_64x64.png"));
        this.stopButton.setTooltip(new Tooltip(XdtsWords.getInstance().TOOL_TIP_logicalNameTable));
        nodeUnit = new FxNodeUnit(null, new Node[]{this.stopButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.borderPane1.setCenter((Node)this.controlPane);
        this.addUrlButton.setOnAction(this.actionEventHandler);
        this.addUrlButton.setText(BcWords.getInstance().add);
        this.addUrlButton.setGraphic((Node)FxImageHelper.createImageView_icon("add_64x64.png"));
        this.addUrlButton.setTooltip(new Tooltip(XdtsWords.getInstance().TOOL_TIP_logicalNameTable));
        nodeUnit = new FxNodeUnit(null, new Node[]{this.addUrlButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.borderPane1.setCenter((Node)this.controlPane);
        this.setTop((Node)this.borderPane1);
        this.tabPane1.setSide(Side.TOP);
        this.splitPane1.getItems().addAll((Object[])new Node[]{this.parseUrlTablePane, this.downloadUrlTablePane, this.tabPane1});
        this.splitPane1.setDividerPositions(new double[]{0.2f, 0.8f});
        this.setContentNode((Node)this.splitPane1);
        this.viwerDesktopPane = new FxxViwerDesktopPane();
        this.generalContentGroup = new FxxGeneralContentGroup();
        this.viwerDesktopPane.show(null);
        FxUtil.defaultInitialize((Node)this);
    }

    public void addTable(String tableName, int index) throws Exception {
        if (FxUtil.findTabByName(this.tabPane1, tableName) != null) {
            return;
        }
        Tab tab1 = new Tab();
        tab1.setGraphic((Node)FxImageHelper.createImageView_icon("table_64x64.png"));
        if (index < 0) {
            this.tabPane1.getTabs().add((Object)tab1);
            this.tabPane1.getSelectionModel().select((Object)tab1);
        } else {
            this.tabPane1.getTabs().add(index, (Object)tab1);
        }
    }

    public void reflesh(String tableName) throws Exception {
        Tab tab = FxUtil.findTabByName(this.tabPane1, tableName);
        if (tab == null) {
            return;
        }
        int index = this.tabPane1.getTabs().indexOf((Object)tab);
        Tab selectedTab = (Tab)this.tabPane1.getSelectionModel().getSelectedItem();
        boolean isSelected = tab == selectedTab;
        this.tabPane1.getTabs().remove((Object)tab);
        this.addTable(tab.getText(), index);
        if (isSelected) {
            tab = FxUtil.findTabByName(this.tabPane1, tableName);
            this.tabPane1.getSelectionModel().select((Object)tab);
        }
    }

    public void reflesh() throws Exception {
        ObservableList tabList = this.tabPane1.getTabs();
        int i = 0;
        while (i < tabList.size()) {
            Tab tab = (Tab)tabList.get(i);
            this.reflesh(tab.getText());
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        XwdlUrlEditPane urlEditPane;
        XwdlElemnt xwdlElemnt;
        super.actionPerformed(ev);
        if (ev.getSource() == this.closeMenuItem) {
            this.closeAction(ev);
        } else if (ev.getSource() != this.startButton && ev.getSource() != this.stopButton && ev.getSource() == this.addUrlButton && (xwdlElemnt = (urlEditPane = new XwdlUrlEditPane()).show(null, FxUtil.getWindow((Node)this))) != null) {
            this.xwdlCondition.addParceUrl(xwdlElemnt.url, 0, String.valueOf(xwdlElemnt.hashCode()));
        }
    }

    protected void closeAction(ActionEvent ev) throws Exception {
        this.close();
    }

    public void close() throws Exception {
        this.stage.close();
    }

    protected void show(Window ownerWindow) throws Exception {
        this.init();
        this.setContents();
        this.createStage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        this.stage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    XwdlDownloadPane.this.close();
                }
                catch (Exception ex) {
                    XwdlDownloadPane.this.handleException(ex);
                }
            }
        });
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                XwdlDownloadPane.this.splitPane1.setDividerPositions(new double[]{0.2f, 0.8f});
            }
        });
        this.stage.setResizable(true);
        Image image = FxImageHelper.getImage("db_64x64.png");
        this.stage.getIcons().add((Object)image);
        FxUtil.setWindowSize((Window)this.stage, 960.0, 800.0, true);
        this.stage.show();
    }

    class InnerDownloadManager
    extends XwdlDownloadEventHandler {
        @Override
        public void parceUrlAdded(XwdlElemnt xwdlElemnt) throws Exception {
            XwdlDownloadPane.this.parseUrlTablePane.add(xwdlElemnt);
        }

        @Override
        public void targetUrlAdded(XwdlElemnt xwdlElemnt) throws Exception {
            XwdlDownloadPane.this.downloadUrlTablePane.add(xwdlElemnt);
        }

        @Override
        public void downloaded(File file, URL url) throws Exception {
            BcLogUtil.debug("downloaded:file=" + file.getPath());
        }
    }
}

