/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.fx;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.util.FxImageUtil;
import jp.co.extreme.module.xsod.common.FxxImageCash;
import jp.co.extreme.module.xsod.common.XsodUtil;
import jp.co.extreme.module.xsod.fx.XsodUiFactory;
import jp.co.extreme.module.xsod.model.XsodMerchandisePack;

class XsodMenuElementPane
extends FxBorderPane {
    StackPane stackPane1 = new StackPane();
    StackPane stackPane2;
    Pane imagePane = new Pane();
    VBox bottomBox = new VBox();
    Text nameText = XsodUiFactory.getInstance().createText(null);
    Text amountText = XsodUiFactory.getInstance().createText(null);
    XsodMerchandisePack merchandisePack;

    public XsodMenuElementPane() throws Exception {
        this.stackPane1.getChildren().add((Object)this.imagePane);
        StackPane.setAlignment((Node)this.imagePane, (Pos)Pos.BOTTOM_CENTER);
        this.bottomBox.setAlignment(Pos.CENTER);
        this.bottomBox.setSpacing(10.0);
        this.bottomBox.getChildren().addAll((Object[])new Node[]{this.nameText, this.amountText});
        this.stackPane2 = XsodUiFactory.getInstance().createBackgrondNode((Node)this.bottomBox, Color.WHITE);
        this.stackPane1.getChildren().add((Object)this.stackPane2);
        StackPane.setAlignment((Node)this.stackPane2, (Pos)Pos.BOTTOM_CENTER);
        this.setCenter((Node)this.stackPane1);
    }

    public void setData(XsodMerchandisePack merchandisePack, double buttonWidth, double buttonHeight, String langCode) throws Exception {
        this.merchandisePack = merchandisePack;
        double imageWidth = buttonWidth - 16.0;
        double imageHeight = buttonHeight - 16.0;
        this.imagePane.getChildren().clear();
        BcLogUtil.debug("imageFileName=" + merchandisePack.merchandise.imageFileName);
        Image image = FxxImageCash.getInstance().getImageNI(merchandisePack.merchandise.imageFileName);
        if (image != null) {
            ImageView imageView = new ImageView(image);
            FxImageUtil.setSizeExtract(imageView, imageWidth, imageHeight);
            this.imagePane.getChildren().add((Object)imageView);
        }
        double boxWidth = imageWidth - 0.0;
        double boxHeight = imageHeight - 170.0;
        this.nameText.setFill((Paint)Color.BLACK);
        this.nameText.setStrokeWidth(1.5);
        this.nameText.setStroke((Paint)Color.BLACK);
        String name = XsodUtil.getName(merchandisePack.merchandise, langCode, true);
        this.nameText.setText(name);
        this.nameText.setWrappingWidth(boxWidth);
        this.nameText.setTextAlignment(TextAlignment.CENTER);
        this.amountText.setFill((Paint)Color.RED);
        this.amountText.setStrokeWidth(1.5);
        this.amountText.setStroke((Paint)Color.RED);
        this.amountText.setTextAlignment(TextAlignment.CENTER);
        String tmpStr = BcNumberUtil.toString(merchandisePack.merchandise.unitAmount, 0);
        this.amountText.setText("\uffe5" + tmpStr);
        this.stackPane2.setMaxSize(boxWidth, boxHeight);
    }
}

