/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.server;

import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.mmd.MmdCellAttribute;
import jp.co.extreme.base.util.BcWordPack;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.base.yaml.BcYamlUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.datasource.util.ScfMmdServerUtil;
import jp.co.extreme.html.util.EtcHtmlUtil;
import jp.co.extreme.module.xdts.dao.XdtsProfileDAO;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xfil.common.XfilConstants;
import jp.co.extreme.module.xfil.common.XfilWords;
import jp.co.extreme.module.xfil.server.XfilServerUtil;
import jp.co.extreme.scf.server.ScfAbstractServerModule;
import jp.co.extreme.sql.context.SqlContext_H2;

public class XfilServerModule
extends ScfAbstractServerModule {
    @Override
    public void init() throws Exception {
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.id", 8, EtcHtmlUtil.toHtml(XfilWords.getInstance().crawlId), 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.crawler_id", 6, EtcHtmlUtil.toHtml(XfilWords.getInstance().crawlerId), 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.file_extention", 32, EtcHtmlUtil.toHtml(BcWords.getInstance().extension), 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.overwrirte", 6, EtcHtmlUtil.toHtml(BcWords.getInstance().overwrirte), 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.target_path", 40, EtcHtmlUtil.toHtml(XfilWords.getInstance().targetPath), 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.exclusion_path", 40, EtcHtmlUtil.toHtml(XfilWords.getInstance().exclusionPath), 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.start_timestamp", Calendar.class, "yyyy/MM/dd HH:mm:ss", 18, EtcHtmlUtil.toHtml(BcWords.getInstance().start, BcWords.getInstance().dateTime), 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.end_timestamp", Calendar.class, "yyyy/MM/dd HH:mm:ss", 18, EtcHtmlUtil.toHtml(BcWords.getInstance().end, BcWords.getInstance().dateTime), 0);
        HashMap<Short, MmdCellAttribute> crawlStatusMap = new HashMap<Short, MmdCellAttribute>();
        XfilConstants.CrawlStatus[] crawlStatusArray = XfilConstants.CrawlStatus.values();
        int n = crawlStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            XfilConstants.CrawlStatus crawlStatus = crawlStatusArray[n2];
            crawlStatusMap.put(new Short(crawlStatus.id), new MmdCellAttribute(crawlStatus.name(), null));
            ++n2;
        }
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.status_id", String.class, null, 0, 0, 8, EtcHtmlUtil.toHtml(BcWords.getInstance().status), crawlStatusMap, 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.note_", 40, EtcHtmlUtil.toHtml(BcWords.getInstance().note), 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawler.id", 6, EtcHtmlUtil.toHtml(XfilWords.getInstance().crawlerId), 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawler.add_timestamp", 16, EtcHtmlUtil.toHtml(BcWords.getInstance().registrationDateTime.toPlain()), 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawler.update_timestamp", 16, EtcHtmlUtil.toHtml(BcWords.getInstance().updateDateTime.toPlain()), 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawler.name_", 20, EtcHtmlUtil.toHtml(XfilWords.getInstance().crawlerName), 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawler.file_extention", 32, EtcHtmlUtil.toHtml(BcWords.getInstance().target, BcWords.getInstance().extension), 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawler.overwrirte", 6, EtcHtmlUtil.toHtml(BcWords.getInstance().overwrirte), 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawler.target_path", 40, EtcHtmlUtil.toHtml(BcWords.getInstance().target, BcWords.getInstance().path), 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawler.exclusion_path", 40, EtcHtmlUtil.toHtml(XfilWords.getInstance().exclusionPath), 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawler.note_", 32, EtcHtmlUtil.toHtml(BcWords.getInstance().note), 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.id", 6, EtcHtmlUtil.toHtml(XfilWords.getInstance().indexId), 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.add_timestamp", 16, EtcHtmlUtil.toHtml(BcWords.getInstance().registrationDateTime), 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.update_timestamp", 16, EtcHtmlUtil.toHtml(BcWords.getInstance().updateDateTime), 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.index_group_id", 5, EtcHtmlUtil.toHtml(BcWords.getInstance().index, new BcWordPack(true, false, BcWords.getInstance().group, BcWords.getInstance().id)), 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.crawl_id", 5, EtcHtmlUtil.toHtml(XfilWords.getInstance().crawlId), 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.scheme_id", 4, "<html><center>scheme_id</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.drive", 4, BcWords.getInstance().drive, 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.directory_", 20, EtcHtmlUtil.toHtml(BcWords.getInstance().directory), 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.name_", 32, EtcHtmlUtil.toHtml(BcWords.getInstance().fileName), 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.extention_", 4, EtcHtmlUtil.toHtml(BcWords.getInstance().fileExtension_abbreviation), 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.size_", 8, EtcHtmlUtil.toHtml(BcWords.getInstance().fileSize), 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.child_count", 12, "<html><center>child_count</center></html>");
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.creation_datetime", Calendar.class, "yyyy/MM/dd HH:mm:ss", 17, EtcHtmlUtil.toHtml(BcWords.getInstance().creationDate), 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.last_modified_datetime", Calendar.class, "yyyy/MM/dd HH:mm:ss", 17, EtcHtmlUtil.toHtml(BcWords.getInstance().modifiedDate), 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.last_access_datetime", Calendar.class, "yyyy/MM/dd HH:mm:ss", 17, EtcHtmlUtil.toHtml(BcWords.getInstance().accessDate), 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.owner", 10, EtcHtmlUtil.toHtml(BcWords.getInstance().owner));
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.posix_permission", 8, EtcHtmlUtil.toHtml(BcWords.getInstance().permission));
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.hidden", Boolean.class, 2, "<html><center>\u96a0<br>\u3057</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.symbolic_link", Boolean.class, 2, "<html><center>SL</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.executable", Boolean.class, 2, "<html><center>\u5b9f<br>\u884c</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.readable", Boolean.class, 2, "<html><center>\u8aad<br>\u53d6</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.writable", Boolean.class, 2, "<html><center>\u66f8<br>\u8fbc</center></html>", 0);
        HashMap<Short, MmdCellAttribute> entityTypeMap = new HashMap<Short, MmdCellAttribute>();
        XfilConstants.FileType[] fileTypeArray = XfilConstants.FileType.values();
        int n3 = fileTypeArray.length;
        n = 0;
        while (n < n3) {
            XfilConstants.FileType fileType = fileTypeArray[n];
            entityTypeMap.put(new Short(fileType.id), new MmdCellAttribute(fileType.symbol, null));
            ++n;
        }
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.entity_type", String.class, null, 0, 0, 2, "<html><center>\u7a2e<br>\u5225</center></html>", entityTypeMap, 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.child_count", 8, EtcHtmlUtil.toHtml(BcWords.getInstance().numberOfNodes));
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.missing_timestamp", Calendar.class, "yyyy/MM/dd HH:mm:ss", 17, EtcHtmlUtil.toHtml(BcWords.getInstance().missing, new BcWordPack(false, false, BcWords.getInstance().dateTime)), 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.width", 4, EtcHtmlUtil.toHtml(BcWords.getInstance().width_px), 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.height", 4, EtcHtmlUtil.toHtml(BcWords.getInstance().height_px), 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.duration_millis", 8, EtcHtmlUtil.toHtml(BcWords.getInstance().length), 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.thumbnail_files", 120, EtcHtmlUtil.toHtml(BcWords.getInstance().thumbnail));
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.tag", 12, "<html><center>TAG</center></html>");
        ScfMmdServerUtil.addColumnNameAndModel("xfil_index_group.id", 5, EtcHtmlUtil.toHtml(new BcWordPack(false, false, BcWords.getInstance().index, BcWords.getInstance().group), BcWords.getInstance().id), 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_index_group.add_timestamp", 16, EtcHtmlUtil.toHtml(BcWords.getInstance().registrationDateTime.toPlain()), 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_index_group.update_timestamp", 16, EtcHtmlUtil.toHtml(BcWords.getInstance().updateDateTime.toPlain()), 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_index_group.name_", 32, EtcHtmlUtil.toHtml(new BcWordPack(false, false, BcWords.getInstance().index, BcWords.getInstance().group), BcWords.getInstance().name), 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_index_group.note_", 40, "<html><center>" + BcWords.getInstance().note + "</center></html>", 2);
        this.createProfile();
        this.loadVideoCaptureConfiguration();
    }

    protected void createProfile() throws Exception {
        DtsSessionFactory dtsSessionFactoryMain = DtsSessionFactoryManegaer.getInstance().getSessionFactory("main");
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSession = dtsSessionFactoryMain.createSession(dtsSessionFactoryMain);){
            this.createProfile_L2(dtsSession);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void createProfile_L2(DtsSession dtsSession) throws Exception {
        XdtsProfile profile = (XdtsProfile)XdtsProfileDAO.getInstance().getById(dtsSession, 1L);
        this.getLogger().debug("profile=" + profile);
        if (profile != null) {
            return;
        }
        profile = new XdtsProfile();
        profile.setDataId(1);
        this.createProfile_H2(profile);
        XdtsProfileDAO.getInstance().putEntity(dtsSession, profile);
        dtsSession.commit();
    }

    protected void createProfile_H2(XdtsProfile profile) throws Exception {
        profile.driver = "org.h2.Driver";
        boolean ifExists = false;
        boolean dbCloseOnExit = true;
        String databaseName = "${DATA_DIR}crawl";
        profile.url = SqlContext_H2.cretaeUrl(SqlContext_H2.Protocol.file, databaseName, ifExists, dbCloseOnExit);
    }

    protected void loadVideoCaptureConfiguration() throws Exception {
        String vPath = "${APP}config/videoCapture.yml";
        String filePath = AfbApplication.getInstance().toReal(vPath);
        File file = new File(filePath);
        Map rootMap = (Map)BcYamlUtil.load(file);
        int maxThreads = (Integer)rootMap.get("maxThreads");
        XfilServerUtil.getInstance().videoCaptureTaskGroup.setMin(1);
        XfilServerUtil.getInstance().videoCaptureTaskGroup.setMax(maxThreads);
        XfilServerUtil.getInstance().tagCreateTaskGroup.setMin(1);
        XfilServerUtil.getInstance().tagCreateTaskGroup.setMax(1);
    }

    @Override
    public void start() throws Exception {
        XfilServerUtil.getInstance().startService1();
    }
}

