/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.fx;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.stage.DirectoryChooser;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.base.util.BcSortUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xfil.common.XfilWords;
import jp.co.extreme.module.xfil.fx.XfilConditionSet;
import jp.co.extreme.module.xfil.model.XfilAnalysisCondition;
import jp.co.extreme.module.xfil.model.XfilCrawler;

class XfilCrawlConditionPane1
extends FxBorderPane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField crawlNameField = new FxTextField();
    FxTextField directoryField = new FxTextField();
    FxButton browsButton = FxUtil.createBrowsButton(null);
    DirectoryChooser directoryChooser = new DirectoryChooser();
    XfilConditionSet conditionSet = new XfilConditionSet();

    public XfilCrawlConditionPane1() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.setCenter((Node)this.centerPane);
        this.setDefault();
        this.conditionSet.initCrawlerUnit(false, null);
        if (this.conditionSet.crawlerComboBox.getItems().size() > 0) {
            ArrayList crawlList = new ArrayList();
            crawlList.addAll(this.conditionSet.crawlerComboBox.getItems());
            BcSortUtil.sort(crawlList, false, new Object[]{"startDateTime"});
            XfilCrawler crawlerWk = (XfilCrawler)BcCollectionUtil.getLast(crawlList);
            this.directoryField.setText(crawlerWk.targetPath);
            this.conditionSet.fileExtentionControl.setInputText(crawlerWk.fileExtention);
        }
        this.crawlNameField.setPrefColumnCount(100);
        FxNodeUnit controlUnit = new FxNodeUnit((Node)new FxLabel(XfilWords.getInstance().crawlerName.toPlain()), new Node[]{this.crawlNameField});
        this.centerPane.addNodeUnit(controlUnit);
        this.directoryField.setPrefColumnCount(100);
        this.browsButton.setOnAction(this.actionEventHandler);
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().directory), new Node[]{this.directoryField, this.browsButton});
        this.centerPane.addNodeUnit(controlUnit);
        this.conditionSet.initIndexGroupUnit(false, true);
        this.centerPane.addNodeUnit(this.conditionSet.indexGroupUnit);
        this.setPrefHeight(140.0);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.browsButton) {
            FxUtil.initDirectoryChooser(this.directoryChooser, this.directoryField.getText());
            File file = this.directoryChooser.showDialog(this.getScene().getWindow());
            if (file != null) {
                this.directoryField.setText(file.getPath());
            }
        }
    }

    protected void setDefault() throws Exception {
        Calendar now = BcTimeUtil.createCalendar();
        String dateTimeStr = BcTimeUtil.toString(now, "yyyy/MM/dd HH:mm:ss");
        this.crawlNameField.setText(String.valueOf(dateTimeStr) + " \u306e\u30af\u30ed\u30fc\u30eb");
        File[] files = File.listRoots();
        ArrayList<String> driveNameList = new ArrayList<String>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            driveNameList.add(file.getPath());
            ++n2;
        }
        this.directoryField.setText(BcCsvUtil.toCsv(driveNameList));
    }

    protected void setData(XfilCrawler crawler) throws Exception {
        this.crawlNameField.setText(crawler.name);
        this.directoryField.setText(crawler.targetPath);
        this.conditionSet.fileExtentionControl.setInputText(crawler.fileExtention);
    }

    public XfilCrawler getCondition() throws Exception {
        XfilAnalysisCondition captureCondition = this.conditionSet.getCondition();
        XfilCrawler crawler = new XfilCrawler();
        crawler.name = this.crawlNameField.getText();
        crawler.targetPath = this.directoryField.getText();
        crawler.fileExtention = captureCondition.fileExtention;
        return crawler;
    }
}

